// +----------------------------------------------------------------------
// | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
// +----------------------------------------------------------------------
// | Copyright (c) 2016~2023 https://www.crmeb.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
// +----------------------------------------------------------------------
// | Author: CRMEB Team <admin@crmeb.com>
// +----------------------------------------------------------------------

import Layout from '@/layout';

const distributionRouter = {
  path: '/distribution',
  component: Layout,
  redirect: '/distribution/index',
  name: 'Distribution',
  meta: {
    title: '分销',
    icon: 'clipboard',
  },
  children: [




    // {
    //   path: 'index1',
    //   component: () => import('@/views/distribution/pages/index1'),
    //   name: 'distributionIndex1',
    //   meta: { title: '111111111111', icon: '' },
    // },

    // {
    //   path: 'index2',
    //   component: () => import('@/views/distribution/pages/index2'),
    //   name: 'distributionIndex2',
    //   meta: { title: '22222222222', icon: '' },
    // },

    // {
    //   path: 'index3',
    //   component: () => import('@/views/distribution/pages/index3'),
    //   name: 'distributionIndex3',
    //   meta: { title: '333333333333', icon: '' },
    // },

    // {
    //   path: 'index4',
    //   component: () => import('@/views/distribution/pages/index4'),
    //   name: 'distributionIndex4',
    //   meta: { title: '44444444444', icon: '' },
    // },




    {
      path: 'index',
      component: () => import('@/views/distribution/index'),
      name: 'distributionIndex',
      meta: { title: '分销员管理', icon: '' },
    },




    {
      path: 'distributionconfig',
      component: () => import('@/views/distribution/config/index'),
      name: 'distributionConfig',
      meta: { title: '分销配置', icon: '' },
    },

    {
      path: 'merchandiseOperations',
      component: () => import('@/views/distribution/merchandiseOperations/index'),
      name: 'merchandiseOperations',
      meta: { title: '商品运营', icon: '' },
    },

    {
      path: 'earningReport',
      component: () => import('@/views/distribution/earningReport'),
      name: 'earningReport',
      meta: { title: '业绩报表', icon: '' },
      children: [
        {
          path: 'distributionPeople',
          component: () => import('@/views/distribution/earningReport/distributionPeople'),
          name: 'distributionPeople',
          meta: { title: '分销员账单', icon: '' },
        },

        {
          path: 'distributionCompany',
          component: () => import('@/views/distribution/earningReport/distributionCompany'),
          name: 'distributionCompany',
          meta: { title: '分销商账单', icon: '' },
        },

        {
          path: 'channelCommission',
          component: () => import('@/views/distribution/earningReport/channelCommission'),
          name: 'channelCommission',
          meta: { title: '渠道佣金', icon: '' },
        },

        {
          path: 'departmentPerformance',
          component: () => import('@/views/distribution/earningReport/departmentPerformance'),
          name: 'departmentPerformance',
          meta: { title: '部门绩效', icon: '' },
        },

        {
          path: 'memberPerformance',
          component: () => import('@/views/distribution/earningReport/memberPerformance'),
          name: 'memberPerformance',
          meta: { title: '成员绩效', icon: '' },
        },
      ]
    },

    {
      path: 'performanceBill',
      component: () => import('@/views/distribution/performanceBill'),
      name: 'performanceBill',
      meta: { title: '业绩账单', icon: '' },
      children: [
        {
          path: 'distributor',
          component: () => import('@/views/distribution/performanceBill/distributor'),
          name: 'performanceDistributor',
          meta: { title: '分销员账单', icon: '' },
        },

        {
          path: 'companyBill',
          component: () => import('@/views/distribution/performanceBill/companyBill'),
          name: 'performanceCompanyBill',
          meta: { title: '分销商账单', icon: '' },
        },

        {
          path: 'channelBill',
          component: () => import('@/views/distribution/performanceBill/channelBill'),
          name: 'performanceChannelBill',
          meta: { title: '渠道商账单', icon: '' },
        },

        {
          path: 'departmentBill',
          component: () => import('@/views/distribution/performanceBill/departmentBill'),
          name: 'performanceDepartmentBill',
          meta: { title: '部门账单', icon: '' },
        },

        {
          path: 'memberBill',
          component: () => import('@/views/distribution/performanceBill/memberBill'),
          name: 'performanceMemberBill',
          meta: { title: '部门成员账单', icon: '' },
        },

        {
          path: 'performanceBillDetail',
          component: () => import('@/views/distribution/performanceBill/performanceBillDetail'),
          name: 'performanceBillDetail',
          meta: { title: '业绩账单详情', icon: '' },
        }
      ]
    },

    {
      path: 'settlementBill',
      component: () => import('@/views/distribution/settlementBill'),
      name: 'SettlementBill',
      meta: { title: '结算单', icon: '' },
      children: [
        {
          path: 'distributor',
          component: () => import('@/views/distribution/settlementBill/distributor'),
          name: 'settleDistributor',
          meta: { title: '分销员结算单', icon: '' },
        },

        {
          path: 'companyBill',
          component: () => import('@/views/distribution/settlementBill/companyBill'),
          name: 'settleCompanyBill',
          meta: { title: '分销商结算单', icon: '' },
        },

        {
          path: 'channelBill',
          component: () => import('@/views/distribution/settlementBill/channelBill'),
          name: 'settleChannelBill',
          meta: { title: '渠道商结算单', icon: '' },
        },

        {
          path: 'departmentBill',
          component: () => import('@/views/distribution/settlementBill/departmentBill'),
          name: 'settleDepartmentBill',
          meta: { title: '部门结算单', icon: '' },
        },

        {
          path: 'memberBill',
          component: () => import('@/views/distribution/settlementBill/memberBill'),
          name: 'settleMemberBill',
          meta: { title: '部门成员结算单', icon: '' },
        },

        {
          path: 'settleBillDetail',
          component: () => import('@/views/distribution/settlementBill/settleBillDetail'),
          name: 'settleBillDetail',
          meta: { title: '结算单详情', icon: '' },
        }
      ]
    }
  ],
};

export default distributionRouter;
