<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
<title>现场勘查</title>
<%@ include file="/WEB-INF/views/include/wechatHead.jsp"%>
<link rel="stylesheet" type="text/css" href="<c:url value='/resources/wechat2/dist/css/survey-ques.css?v=${version}'/>" />
<script type="text/javascript" src="<c:url value='/resources/commonJS/wechat/jq-signature.js?v=${version}'/>"></script>
</head>
<body>
<div class="js-signature" id="jsSign" data-line-color="#bc0000" data-auto-fit="true" style="width: 100%;" data-height="200"></div>
<div class="text-center submit-btn">
	<button type="button" class="btn btn-primary bg-2e9fe3" onclick="javascript:parent.layer.closeAll();">取消</button>
	<button type="button" class="btn btn-primary bg-2e9fe3" onclick="clearCanvas();">重签</button>
	<button type="button" class="btn btn-primary bg-2e9fe3" onclick="saveSignature();" id="saveSignBtn" disabled="disabled">确定</button>
</div>

<script type="text/javascript">

	$(function() {
		setSignArea();
	});

	function getClientWidth() {
		var clientWidth = $(window).width();
		return clientWidth;
	}
	
	function getClientHeight(){
		var clientHeight = $(window).height();
		return clientHeight -90;
	}
	
	function setSignArea() {
		$("#jsSign").width(getClientWidth());//data-height
 		$("#jsSign").attr("data-height",getClientHeight());
 		$("#jsSign").height(getClientHeight());
		$('.js-signature').jqSignature();
		$('#jsSign').on('jq.signature.changed', function() {
			$('#saveSignBtn').attr('disabled', false);
		});
	}

	function clearCanvas() {
		$('#jsSign').jqSignature('clearCanvas');
		$('#saveSignBtn').attr('disabled', true);
	}

	function saveSignature() {
		var dataUrl = $('#jsSign').jqSignature('getDataURL');
		console.log(dataUrl);
		parent.getSignature(dataUrl);
		parent.layer.closeAll();
	}
</script>
</body>
</html>