<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<style>
    #previewModal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: rgba(0,0,0,0.8);
        z-index: 9999;
    }
    #previewModal img {
        max-width: 100%;
        max-height: 100%;
        margin: auto;
        display: block;
    }
</style>
<form id="questionForm">
    <input type="hidden" value="${question.oid }" name="oid" id="editQuestionId">
    <input type="hidden" value="${question.sort }" name="sort" id="sort">
    <input type="hidden" value="${question.questionType }" id="questionType">

    <div class="issue-content">
        <c:choose>
            <c:when test="${question.questionType eq 'CARRYOVER' }">
                <div class="issue-consub pt-0">
                    <h5>${questionIndex }、${question.question }</h5>
                    <h6>上次勘查结果：</h6>
                    <p>${question.answer }</p>
                </div>
                <div class="issue-consub">
                    <h6>上次勘查图片：</h6>
                    <div class="list-img clearfix">
                        <ul>
                            <c:forEach items="${question.lastSurvey.photos }" var="photo">
                                <li class="portrait"><img onclick="preViewImg1('${photo.path}');" src="${photo.path}"
                                                          class="pic"/></li>
                            </c:forEach>
                        </ul>
                    </div>
                </div>
                <div class="issue-consub" style="border: none;">
                    <h6>承办方整改情况：</h6>
                    <p>${question.lastSurvey.surveyReform.result ne null && question.lastSurvey.surveyReform.result ne '' ? question.lastSurvey.surveyReform.result:'暂无' }</p>
                    <div class="hand-down clearfix">
                        <ul class="rad-io">
                            <li>
                                <p>
                                    <input type="radio" name="needReform" id="needReform1" value="0"
                                        ${question.nextSurvey eq false ? 'checked="checked"':'' }>
                                    <label for="needReform1" class="pull-left"></label> <em class="pull-left">已整改</em>
                                </p>
                            </li>
                            <li>
                                <p>
                                    <input type="radio" name="needReform" id="needReform2" value="1"
                                        ${question.nextSurvey ? 'checked="checked"':'' }>
                                    <label for="needReform2" class="pull-left"></label> <em class="pull-left">未整改</em>
                                </p>
                            </li>
                        </ul>
                    </div>
                </div>
            </c:when>
            <c:otherwise>
                <div class="issue-consub pt-0" style="border: none;">
                    <c:choose>
                        <c:when test="${empty question }">
                            <input type="hidden" value="" name="questionnaire.oid" id="questionnaireOid">
                            <div class="in-text"><input type="text" placeholder="请输入要添加的问题" id="question"
                                                        name="question"></div>
                        </c:when>
                        <c:otherwise>
                            <h5>${questionIndex }、${question.question }</h5>
                            <p>${question.answerTip }</p>
                        </c:otherwise>
                    </c:choose>
                    <div class="pos-rel">
                        <textarea name="answer" id="answer" rows="10" placeholder="请输入勘查结果" maxlength="200"
                                  oninput="showInputNum(this,'stat_total');">${question.answer }</textarea>
                        <div class="gray"><span id="stat_total" class="b light">0</span>/<span id="stat_max"
                                                                                               class="b ligh">200</span>
                        </div>
                    </div>
                </div>
            </c:otherwise>
        </c:choose>
        <div class="issue-consub pt-0">
            <div class="upload-pictures">
                <div class="uppi-war clearfix">
                    <input name="delPhotoIds" type="hidden" id="delPhotoIds">
                    <div id="mediaIdsArea"></div>
                    <ul id="showImgArea" style="margin-bottom: 0;">
                        <c:forEach items="${question.photos }" var="photo">
                            <li id="showImg${photo.oid}">
                                <p><img onclick="preViewImg1('${photo.path}');" src="${photo.path}" class="pic"></p>
                                <span onclick="removeImg('${photo.oid}');"><img
                                        src="<c:url value='/resources/wechat2/images/picture-close.png'/>"
                                        class="closePic"/></span>
                            </li>
                        </c:forEach>
                    </ul>
                    <ul style="margin-bottom: 0;">
                        <li>
                            <p><img src="<c:url value='/resources/wechat2/images/add-picture.png'/>" class="pic"
                                    <%--onclick="chooseImage();"--%>><input style="position: absolute;
    top: 0;
    right: 0;
    opacity: 0;
    width: 100px;
    height: 100px;
    z-index: 99;" name="photos" id="photos" type="file"></p>
                        </li>
                    </ul>
                </div>
                <span>注: 您可以上传多张现场图片</span>
                <c:if test="${question.questionType ne 'CARRYOVER' }">
                    <div class="in-check clearfix">
                        <ul>
                            <li>
						<span class="check-box">
							<input type="checkbox" name="needReform" value="1"
                                   id="needReform" ${question.nextSurvey ? 'checked="checked"':'' }>
							<label for="needReform"></label>
						</span>
                                <span style="margin-left: 5px;"><label for="needReform">选中的问题将作为整改意见，承办方将需要对此意见在pss平台反馈整改情况</label></span>
                            </li>
                        </ul>
                    </div>
                </c:if>
                <div id="previewModal">
                    <img id="previewImage" src="" alt="预览图片">
                </div>
            </div>
        </div>
    </div>
    <div class="text-center submit-btn">
        <a href="javascript:submitQuestionForm();" class="btn btn-primary bg-2e9fe3">保存</a>
        <a href="javascript:closePage();" class="btn btn-primary bg-2e9fe3">返回</a>
    </div>
</form>
<script type="text/javascript">
    var randNum = Math.floor(100000 + Math.random() * 900000);
    /*document.getElementById('photos').addEventListener('change', function(e) {
        var file = e.target.files[0];
        if(file == undefined){
            return;
        }
        var reader = new FileReader();
        $('#photos').val('');
        reader.onload = function(e) {
            console.log(e.target.result);
            // 在这里处理图片，例如显示在img元素中或上传到服务器
            $.ajax({
                type: 'POST',
                url:baseUrl + '/wechat/survey/uploadPhotosFile.json',
                dataType:"json",
                data: {'photos':e.target.result,'randNum':randNum},
                success: function(json){
                    if(json.status == '200') {
                        var ret = json.data;
                        var serverId = ret.serverId;
                        var localData = ret.photos;
                        $("#mediaIdsArea").append("<input type='hidden' name='mediaIds' id='"+serverId+"' value='"+serverId+"'>");
                        var showImg = "";
                        showImg = "<li id='showImg"+serverId+"'><p>";
                        showImg = showImg + "<img onclick='preViewImg1(\""+localData+"\")' src='"+localData+"' class='pic'></p>";
                        showImg = showImg + "<span onclick='removeNewImg(\""+serverId+"\")'><img class='closePic' src='"+baseUrl+"/resources/wechat2/images/picture-close.png' /></span></li>";
                        $("#showImgArea").append(showImg);
                    }else{
                        layer.msg(json.message);
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.msg(textStatus);
                }
            });
        };
        reader.readAsDataURL(file);
    });*/
    document.getElementById('photos').addEventListener('change', function(e) {
        var file = e.target.files[0];
        if(file == undefined){
            return;
        }
        $('#photos').val('');
        var formData = new FormData();
        formData.append('photos', file);
        formData.append('randNum', randNum);
        // 在这里处理图片，例如显示在img元素中或上传到服务器
        $.ajax({
            type: 'POST',
            url:baseUrl + '/wechat/survey/uploadPhotosFile.json',
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(json){
                if(json.status == '200') {
                    var ret = json.data;
                    var serverId = ret.serverId;
                    var localData = ret.photos;
                    $("#mediaIdsArea").append("<input type='hidden' name='mediaIds' id='"+serverId+"' value='"+serverId+"'>");
                    var showImg = "";
                    showImg = "<li id='showImg"+serverId+"'><p>";
                    showImg = showImg + "<img onclick='preViewImg1(\""+localData+"\")' src='"+localData+"' class='pic'></p>";
                    showImg = showImg + "<span onclick='removeNewImg(\""+serverId+"\")'><img class='closePic' src='"+baseUrl+"/resources/wechat2/images/picture-close.png' /></span></li>";
                    $("#showImgArea").append(showImg);
                }else{
                    layer.msg(json.message);
                }
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                layer.msg(textStatus);
            }
        });
    });

    // 图片预览模态框关闭功能
    document.getElementById('previewModal').addEventListener('click', function(e) {
        if (e.target === this) {
            this.style.display = 'none';
        }
    });
    function preViewImg1(url){
        $('#previewImage').attr('src',url);
        // 显示预览模态框
        var previewModal = document.getElementById('previewModal');
        previewModal.style.display = 'block';
    }

    function submitQuestionForm() {
        if (checkFormInput()) {
            var loadIndex = layer.load(0, {shade: [0.3, '#808080']});
            var editQuestionId = $("#editQuestionId").val();
            if (editQuestionId == "") {
                var questionnaireOid = $("#questionnaireId").val();
                $("#questionnaireOid").val(questionnaireOid);

                var sort = $("#questionIndex").val();
                $("#sort").val(parseInt(sort) + 1);
            }
            $.ajax({
                type: 'POST',
                url: baseUrl + "/wechat/survey/saveSurveyQuestion.json",
                data: $("#questionForm").serialize(),
                dataType: "json",
//			async :false,
                success: function (data) {
                    layer.close(loadIndex);
                    if (data.status == "200") {
                        toastrSuccess(data.message);
                        if (editQuestionId != "") {
                            $("#disabled" + editQuestionId).html("<img src='" + baseUrl + "/resources/wechat2/images/tick.jpg' width='20' height='16'>");
                            $("#finishAnswer" + editQuestionId).attr("checked", "checked");
                        } else {
                            var questionIndex = $("#questionIndex").val();
                            var question = $("#question").val();
                            var questionStr = '';
                            editQuestionId = data.questionId;
                            if (surveyView) {
                                $("#questionIndex").val(parseInt(questionIndex) + 1);
                                parent.reloadPage();
                            } else {
                                showNewQuestion(editQuestionId, questionIndex, question);
                                $("#questionIndex").val(parseInt(questionIndex) + 1);
                            }
                        }
                        closePage();
                    } else {
                        toastrError(data.message);
                    }
                },
                error: function (e) {
                    layer.close(loadIndex);
                    toastrError(e);
                }
            });
        }
    }

    function checkFormInput() {
        var editQuestionId = $("#editQuestionId").val();
        var questionType = $("#questionType").val();
        if (questionType == "CARRYOVER") {
            var needReform = $('input[name="needReform"]:checked').val();
            if (needReform != "0" && needReform != "1") {
                toastrError("请确认是否已整改");
                return false;
            }
            return true;
        }
        if (editQuestionId == "") {
            var question = $("#question").val();
            if (question == "") {
                toastrError("请输入勘查问题！");
                return false;
            }
        }
        var answer = $("#answer").val();
        if (answer == "") {
            toastrError("请输入勘查结果！");
            return false;
        }
        return true;
    }

    function showInputNum(obj, showId) {
        $("#" + showId).html(obj.value.length);
    }

    function closePage() {
        $("body").removeClass("unoverflow");
        $('.modal').trigger('close');
    }

    function removeImg(photoId) {
        $("#showImg" + photoId).remove();
        $("#delPhotoIds").val($("#delPhotoIds").val() + "#" + photoId);
    }

    function removeNewImg(photoId) {
        $("#showImg" + photoId).remove();
        $("#" + photoId).remove();
    }

</script>
