<%@ page contentType="text/html;charset=UTF-8" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE html>
<html>
<head>
	<%@include file="/WEB-INF/views/include/head.jsp" %>
	<%@ include file="/WEB-INF/views/include/wechatHead.jsp"%>
	<link rel="stylesheet" type="text/css" href="${ctxStatic }/wechat2/dist/css/survey-ques.css?v=${version}" />
</head>
<%@ page isELIgnored="false"%>
<body>
<div class="pageContent" >
	<div class="row">
		<div class="col-sm-12">
			<div class="ibox float-e-margins">
				<div class="ibox-title text-center">
					<h3>${questionnaire.feedBack.surveyTask.name } ${questionnaire.surveyStep.name } ${questionnaire.venue.name }</h3>
				</div>
				<div class="ibox-content">
					<c:set var="questionIndex" value="1" />
					<div class="issue-content">
						<div class="isscon-title"><h4>固定问题</h4></div>
						<c:forEach items="${surveyInfoList }" var="surveyInfo">
							<c:if test="${surveyInfo.questionType eq 'FIXED' }">
								<div class="issue-consub">
									<h5 class="hand-down clearfix">${questionIndex}、${surveyInfo.question }</h5>
									<c:if test="${ not empty surveyInfo.answer }"><p>${surveyInfo.answer }</p></c:if>
									<c:if test="${ not empty surveyInfo.photos }">
										<div class="list-img clearfix addimg-war">
											<ul>
												<c:forEach items="${ surveyInfo.photos }" var="photo">
													<li id="imgDetail_${photo.oid }">
														<p><img onclick="preViewImg('${photo.path }');" src="${photo.path }" class="pic"></p>
														<span onclick="removeImg('${photo.oid }');"><img src="<c:url value='/resources/wechat2/images/picture-close.png'/>" class="closePic" /></span>
													</li>
												</c:forEach>
											</ul>
										</div>
									</c:if>
								</div>
								<c:set var="questionIndex" value="${questionIndex+1 }" />
							</c:if>
						</c:forEach>
					</div>
					<div class="issue-content">
						<div class="isscon-title"><h4>遗留问题</h4></div>
						<c:forEach items="${surveyInfoList }" var="surveyInfo">
							<c:if test="${surveyInfo.questionType eq 'CARRYOVER' }">
								<div class="issue-consub">
									<h5 class="hand-down clearfix">${questionIndex}、${surveyInfo.question }</h5>
									<h6>上次勘查结果：</h6>
									<p>${surveyInfo.answer }</p>
								</div>
								<c:if test="${ not empty surveyInfo.lastSurvey.photos }">
									<div class="issue-consub">
										<h6>上次勘查图片：</h6>
										<div class="list-img clearfix addimg-war">
											<ul>
												<c:forEach items="${ surveyInfo.lastSurvey.photos }" var="photo">
													<li id="imgDetail_${photo.oid }">
														<p><img onclick="preViewImg('${photo.path }');" src="${photo.path }" class="pic"></p>
														<span onclick="removeImg('${photo.oid }');"><img src="<c:url value='/resources/wechat2/images/picture-close.png'/>" class="closePic" /></span>
													</li>
												</c:forEach>
											</ul>
										</div>
									</div>
								</c:if>

								<div class="issue-consub">
									<h6>承办方整改情况：</h6>
									<p>${surveyInfo.lastSurvey.surveyReform.result }</p>
									<div class="changes clearfix">
											${surveyInfo.nextSurvey ? '<span class="bg-f98718">未整改</span>':'<span class="bg-49a61a">已整改</span>' }
									</div>
									<div class="list-img clearfix addimg-war">
										<ul>
											<c:forEach items="${surveyInfo.photos }" var="photo">
												<li id="imgDetail_${photo.oid }">
													<p><img onclick="preViewImg('${photo.path }');" src="${photo.path }" class="pic"></p>
													<span onclick="removeImg('${photo.oid }');"><img src="<c:url value='/resources/wechat2/images/picture-close.png'/>" class="closePic" /></span>
												</li>
											</c:forEach>
										</ul>
									</div>
								</div>
								<c:set var="questionIndex" value="${questionIndex+1 }" />
							</c:if>
						</c:forEach>
					</div>
					<div class="issue-content">
						<div class="isscon-title"><h4>开放问题</h4></div>
						<c:forEach items="${surveyInfoList }" var="surveyInfo">
							<c:if test="${surveyInfo.questionType eq 'UNFIXED' }">
								<div class="issue-consub">
									<h5 class="hand-down clearfix">${questionIndex}、${surveyInfo.question }</h5>
									<c:if test="${ not empty surveyInfo.answer }"><p>${surveyInfo.answer }</p></c:if>
									<c:if test="${ not empty surveyInfo.photos }">
										<div class="list-img clearfix addimg-war">
											<ul>
												<c:forEach items="${ surveyInfo.photos }" var="photo">
													<li id="imgDetail_${photo.oid }">
														<p><img onclick="preViewImg('${photo.path }');" src="${photo.path }" class="pic"></p>
														<span onclick="removeImg('${photo.oid }');"><img src="<c:url value='/resources/wechat2/images/picture-close.png'/>" class="closePic" /></span>
													</li>
												</c:forEach>
											</ul>
										</div>
									</c:if>
								</div>
								<c:set var="questionIndex" value="${questionIndex+1 }" />
							</c:if>
						</c:forEach>
					</div>
					<div class="issue-content">
						<div class="isscon-title"><h4>补充问题</h4></div>
						<c:forEach items="${surveyInfoList }" var="surveyInfo">
							<c:if test="${surveyInfo.questionType eq 'SUPPLEMENT' }">
								<div class="issue-consub">
									<h5 class="hand-down clearfix">${questionIndex}、${surveyInfo.question }</h5>
									<c:if test="${ not empty surveyInfo.answer }"><p>${surveyInfo.answer }</p></c:if>
									<c:if test="${ not empty surveyInfo.photos }">
										<div class="list-img clearfix addimg-war">
											<ul>
												<c:forEach items="${ surveyInfo.photos }" var="photo">
													<li id="imgDetail_${photo.oid }">
														<p><img onclick="preViewImg('${photo.path }');" src="${photo.path }" class="pic"></p>
														<span onclick="removeImg('${photo.oid }');"><img src="<c:url value='/resources/wechat2/images/picture-close.png'/>" class="closePic" /></span>
													</li>
												</c:forEach>
											</ul>
										</div>
									</c:if>
								</div>
								<c:set var="questionIndex" value="${questionIndex+1 }" />
							</c:if>
						</c:forEach>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
</div>
<%@include file="/WEB-INF/views/include/foot.jsp" %>
</body>
<script>

	function preViewImg(imgPath){
	    top.viewImg(imgPath);
	}

	function removeImg(photoId){
        //询问框
        layer.confirm('删除后将无法找回，确认是否删除？', {
            btn: ['确定','取消'] //按钮
        }, function(){
            var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
            $.ajax({
                type : 'POST',
                url : baseUrl + "/manage/surveyReport/removeImg.json",
                data : {"oid":photoId},
//			async :false,
                dataType : "json",
                success : function(data) {
                    layer.close(loadIndex);
                    if(data.successful){
                        $("#imgDetail_"+photoId).remove();
                        layer.msg("删除成功");
                    }else{
                        layer.msg("删除失败");
                    }
                },
                error: function(e) {
                    layer.close(loadIndex);
                }
            });
        }, function(){
        });
	}
</script>
</html>
