package com.bcxin.survey.wechat.menuutils;

import com.bcxin.survey.domain.wechat.AccessToken;
import com.bcxin.survey.utils.GlobalResources;
import com.bcxin.survey.wechat.utils.WeixinUtil;


/**
 * 菜单管理器类
 * 
 * 
 * @date 2014-11-24
 */
public class MenuManager {
	
	public static void main(String[] args) {

		System.out.println(GlobalResources.APPID);
		System.out.println(GlobalResources.DOMAINNAME);
		// 调用接口获取access_token
		AccessToken at = WeixinUtil.getAccessToken(GlobalResources.APPID, GlobalResources.APPSECRET);
        System.out.println(at.getToken()); 
		if (null != at) {
			// 调用接口查询菜单
			//WeixinUtil.getMenu(at.getToken());
			// 调用接口删除菜单，删除原有菜单
			int resultD = WeixinUtil.deleteMenu(at.getToken());
			if (0 == resultD) {
				// 调用接口创建菜单
				int result = WeixinUtil.createMenu(getMenu(),at.getToken());
				// 判断菜单创建结果
				if (0 == result)
					System.out.println("菜单创建成功！");
				else
					System.out.println("菜单创建失败，错误码：" + result);
			} else {
				System.out.println("菜单删除失败，错误码：" + resultD);
			}
		}
	}

	/**
	 * 组装菜单数据
	 * 
	 * @return
	 */
	private static Menu getMenu() {

		ViewButton vbtn11 = new ViewButton();
		vbtn11.setName("我的任务");
		vbtn11.setType("view");
		vbtn11.setUrl("https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + GlobalResources.APPID + "&redirect_uri=http://" + GlobalResources.DOMAINNAME + "/wechat/task/taskList/init?weChat=1&response_type=code&scope=snsapi_userinfo&state=1#wechat_redirect");
		
		ViewButton vbtn12 = new ViewButton();
		vbtn12.setName("我的日程");
		vbtn12.setType("view");
		vbtn12.setUrl("https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + GlobalResources.APPID + "&redirect_uri=http://" + GlobalResources.DOMAINNAME + "/wechat/plan/surveyPlan/init?weChat=1&response_type=code&scope=snsapi_userinfo&state=1#wechat_redirect");
		
		ViewButton vbtn13 = new ViewButton();
		vbtn13.setName("登出系统");
		vbtn13.setType("view");
		vbtn13.setUrl("http://" + GlobalResources.DOMAINNAME + "/j_spring_security_logout");
		

		ViewButton vbtn21 = new ViewButton();
		vbtn21.setName("勘查问卷");
		vbtn21.setType("view");
		vbtn21.setUrl("https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + GlobalResources.APPID + "&redirect_uri=http://" + GlobalResources.DOMAINNAME + "/wechat/question/init?weChat=1&response_type=code&scope=snsapi_userinfo&state=1#wechat_redirect");

		
		ViewButton vbtn22 = new ViewButton();
		vbtn22.setName("开始勘查");
		vbtn22.setType("view");
		vbtn22.setUrl("https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + GlobalResources.APPID + "&redirect_uri=http://" + GlobalResources.DOMAINNAME + "/wechat/survey/siteSurvey/init?weChat=1&response_type=code&scope=snsapi_userinfo&state=1#wechat_redirect");
		
		ViewButton vbtn31 = new ViewButton();
		vbtn31.setName("新增场馆");
		vbtn31.setType("view");
		vbtn31.setUrl("https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + GlobalResources.APPID + "&redirect_uri=http://" + GlobalResources.DOMAINNAME + "/wechat/venue/addVenue/init?weChat=1&response_type=code&scope=snsapi_userinfo&state=1#wechat_redirect");

		
		ViewButton vbtn32 = new ViewButton();
		vbtn32.setName("修改场馆");
		vbtn32.setType("view");
		vbtn32.setUrl("https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + GlobalResources.APPID + "&redirect_uri=http://" + GlobalResources.DOMAINNAME + "/wechat/venue/venueList/init?weChat=1&response_type=code&scope=snsapi_userinfo&state=1#wechat_redirect");
			

		ComplexButton mainBtn1 = new ComplexButton();
		mainBtn1.setName("个人中心");
		mainBtn1.setSub_button(new ViewButton[] { vbtn11, vbtn12, vbtn13});
//		mainBtn1.setSub_button(new ViewButton[] { vbtn11, vbtn12});

		ComplexButton mainBtn2 = new ComplexButton();
		mainBtn2.setName("现场勘查");
		mainBtn2.setSub_button(new ViewButton[] { vbtn21, vbtn22});

		ComplexButton mainBtn3 = new ComplexButton();
		mainBtn3.setName("场馆维护");
		mainBtn3.setSub_button(new ViewButton[] { vbtn31, vbtn32});

		/**
		 * 这是公众号目前的菜单结构，每个一级菜单都有二级菜单项<br>
		 * 
		 * 在某个一级菜单下没有二级菜单的情况，menu该如何定义呢？<br>
		 * 比如，第三个一级菜单项不是“更多体验”，而直接是“幽默笑话”，那么menu应该这样定义：<br>
		 * menu.setButton(new Button[] { mainBtn1, mainBtn2, btn33 });
		 */
		Menu menu = new Menu();
		menu.setButton(new Button[] { mainBtn1, mainBtn2, mainBtn3 });

		return menu;
	}
}
