package com.bcxin.survey.service.wechat;

import com.bcxin.survey.dao.report.BaseDao;
import com.bcxin.survey.domain.survey.SurveyReform;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Service
@Transactional
public class SurveyReformServiceImpl implements SurveyReformService {

	@Autowired
	private BaseDao baseDao;

	@Override
	public boolean saveOrUpdate(SurveyReform photo){
		boolean flag = true;
		try {
			photo.setUpdateOn(new Date());
			baseDao.saveOrUpdate(photo);		
		}catch(Exception e) {
			flag = false;
		}
		return flag;
	}

	@Override
	public boolean delete(SurveyReform photo){
		boolean flag = true;
		try {
			baseDao.delete(photo);		
		}catch(Exception e) {
			flag = false;
		}
		return flag;
	}

	@Override
	public SurveyReform findSurveyReformByOid(long oid){
		return baseDao.get(SurveyReform.class, oid);
	}
}
