package com.bcxin.survey.service.wechat;

import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.SurveyPlan;
import net.sf.json.JSONObject;

import java.util.Date;
import java.util.List;

public interface SurveyPlanService {

	boolean saveOrUpdate(SurveyPlan surveyPlan);

	boolean delete(SurveyPlan surveyPlan);

	SurveyPlan findSurveyPlanByOid(long oid);

	List<SurveyPlan> findSurveyPlanByTaskId(long taskId);

	JSONObject editSurveyPlan(SurveyPlan surveyPlan);

	List<SurveyPlan> findSurveyPlanListByUserAndDate(User user, Date beginTime, Date endTime);
	
	void planListForSort(long taskId);
	
	List<SurveyPlan> findSurveyPlanListBySurveyTaskId(long taskId);

	SurveyPlan findSurveyPlanByTaskIdAndTime(long taskId, int time);

	List<SurveyPlan> findSurveyPlanListByFeedBackId(long feedBackId);

	List<SurveyPlan> findSurveyPlanListByFeedBackId(Long feedbackId, Long venueId);

	List<SurveyPlan> findSurveyPlanListByQuestionnaireId(Long questionnaireId);

	List<Object> findSurveyPlanBySurveyTaskId(Long surveyTaskId);
}