package com.bcxin.survey.enums.report;

import java.util.ArrayList;
import java.util.List;
/**
 * 
* @ClassName: UserRole  
* @Description: 角色枚举类
* @author 
* @date 2016年7月10日 下午2:36:59  
*
 */
public enum UserRole {

	//勘查专家
	EXPERT {public String getValue(){return "4";} public String getEname(){return "EXPERT";} public String getName(){return "勘查专家";} },
	
	PM {public String getValue(){return "10";}public String getEname(){return "PM";}  public String getName(){return "项目经理";}},
	
	CM {public String getValue(){return "12";} public String getEname(){return "CM";} public String getName(){return "勘查人员";}},
	
	ADMIN {public String getValue(){return "20";} public String getEname(){return "ADMIN";} public String getName(){return "管理员";}},
	
	SUPERADMIN {public String getValue(){return "99";} public String getEname(){return "SUPERADMIN";} public String getName(){return "超级管理员";}};

    public abstract String getValue();
    
    public abstract String getName();
    
    public abstract String getEname();
    
    public static List<UserRole> list(){
    	List<UserRole> list = new ArrayList<UserRole>();
    	list.add(EXPERT);
    	list.add(PM);
    	list.add(CM);
    	list.add(ADMIN);
    	return list;
    }
    /**
     * 
    * @Title: backlist  
    * @Description: 后台获取可设置角色
    * @param @return    设定文件  
    * @return List<UserRole>    返回类型  
    * @throws
     */
    public static List<UserRole> backlist(){
    	List<UserRole> list = new ArrayList<UserRole>();
    	list.add(EXPERT);
    	list.add(PM);
    	list.add(CM);
    	list.add(ADMIN);
    	return list;
    }
    
    public static UserRole convertName(String name){
    	if("勘查人员".equals(name)){
    		return CM;
    	} else if("勘查专家".equals(name)){
    		return EXPERT;
    	} else if("项目经理".equals(name)){
    		return PM;
    	} else{
    		return null;
    	}
    }
    
    public static UserRole convert_name(String name){
    	if("PM".equals(name)){
    		return PM;
    	} else if("EXPERT".equals(name)){
    		return EXPERT;
    	} else if("CM".equals(name)){
    		return CM;
    	} else if("ADMIN".equals(name)){
    		return ADMIN;
    	} else if("SUPERADMIN".equals(name)){
    		return SUPERADMIN;
    	} else{
    		return null;
    	}
    }
    
    
    public static boolean isBackRole(List<UserRole> roles){
    	List<UserRole> maRoleList = new ArrayList<UserRole>();
    	maRoleList.add(ADMIN);
    	maRoleList.add(PM);
    	for ( UserRole role : maRoleList ) {
    		if ( roles.contains(role) ) {
    			return true;
    		}
    	}
    	return false;
    }
}
