package com.bcxin.survey.enums.report;

import java.util.ArrayList;
import java.util.List;

public enum ReportSubStep {

	CREATEPROJECT{public String getValue(){return "10_10";} public String getCname(){return "成功创建了项目";} public String getEname(){return "CREATEPROJECT";}},
	
	PAYMENT {public String getValue(){return "10_20";} public String getCname(){return "成功支付了费用";} public String getEname(){return "PAYMENT";}}, 
	
	FILESUBMIT {public String getValue(){return "20_10";} public String getCname(){return "成功提交了材料";} public String getEname(){return "FILESUBMIT";}}, 
	
	FILETRIAL  {public String getValue(){return "20_20";} public String getCname(){return "材料完备性检核已完成";}public String getEname(){return "FILETRIAL";}},
	
	FILEUPDATE  {public String getValue(){return "20_30";} public String getCname(){return "材料修改中";}public String getEname(){return "FILEUPDATE";}},
	
	FIRSTSURVEY  {public String getValue(){return "20_40";} public String getCname(){return "第一阶段勘查已完成";}public String getEname(){return "FIRSTSURVEY";}},
	
	REPORTWRITING {public String getValue(){return "20_50";} public String getCname(){return "风险评估报告已完成";}public String getEname(){return "REPORTWRITING";}},
	
	ACTIVITYAPPROVAL {public String getValue(){return "30_10";} public String getCname(){return "活动审批";}public String getEname(){return "ACTIVITYAPPROVAL";}},
	
	SECONDSURVEY {public String getValue(){return "30_20";} public String getCname(){return "第二阶段勘查已完成";}public String getEname(){return "SECONDSURVEY";}},
	
	SUPERVISIONREPORT{public String getValue(){return "30_30";} public String getCname(){return "监理报告已完成";}public String getEname(){return "SUPERVISIONREPORT";}}, 
	
	THIRDSURVEY {public String getValue(){return "40_10";} public String getCname(){return "第三阶段勘查已完成";}public String getEname(){return "THIRDSURVEY";}},
	
	PROJECTEND {public String getValue(){return "40_20";} public String getCname(){return "项目结束";}public String getEname(){return "PROJECTEND";}}; 

    public abstract String getValue();
    
    public abstract String getCname();
    
    public abstract String getEname();
    
    public static ReportSubStep convertValue(String value){
    	if ( "10_10".equals(value) ) {
    		return ReportSubStep.CREATEPROJECT;
    	} else if ( "10_20".equals(value) ) {
    		return ReportSubStep.PAYMENT;
    	} else if ("20_10".equals(value)) {
    		return ReportSubStep.FILESUBMIT;
    	} else if ("20_20".equals(value)) {
    		return ReportSubStep.FILETRIAL;
    	} else if ("20_30".equals(value)) {
    		return ReportSubStep.FILEUPDATE;
    	} else if ("20_40".equals(value)) {
    		return ReportSubStep.FIRSTSURVEY;
    	} else if ("20_50".equals(value)) {
    		return ReportSubStep.REPORTWRITING;
    	} else if ("30_10".equals(value)) {
    		return ReportSubStep.ACTIVITYAPPROVAL;
    	} else if ("30_20".equals(value)) {
    		return ReportSubStep.SECONDSURVEY;
    	} else if ("30_30".equals(value)) {
    		return ReportSubStep.SUPERVISIONREPORT;
    	} else if ("40_10".equals(value)) {
    		return ReportSubStep.THIRDSURVEY;
    	} else if ("40_20".equals(value)) {
    		return ReportSubStep.PROJECTEND;
    	} 
    	return null;
    }
    
    public static List<ReportSubStep> getReportSubStepBySuperiorStep(ReportStep step){
    	ReportSubStep[] subSteps = ReportSubStep.values();
    	List<ReportSubStep> subStepList = new ArrayList<ReportSubStep>();
    	for (ReportSubStep reportSubStep : subSteps) {
			if(reportSubStep.getValue().startsWith(step.getValue()+"_")){
				subStepList.add(reportSubStep);
			}
		}
    	return subStepList;
    }
    
    public static ReportStep getReportStepBySubStep(ReportSubStep subStep){
    	if(subStep == null)
    		return null;
		String stepValue = subStep.getValue();
		stepValue = stepValue.substring(0,stepValue.indexOf("_"));
    	return ReportStep.convertValue(stepValue);
    }
}
