package com.bcxin.survey.domain.survey;

import com.bcxin.survey.domain.BaseBean;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import javax.persistence.*;

/**
 * 查勘现场照片
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_Survey_Photo")
@Inheritance(strategy = InheritanceType.JOINED)
@Proxy(proxyClass = Survey_Photo.class)
@DynamicInsert(true)
@DynamicUpdate(true)
public class Survey_Photo extends BaseBean{

	 
	private static final long serialVersionUID = 1L;

	private String ossKey;
	
	private String path; //图片路径

	private String mediaId; //微信图片路径

	@ManyToOne(targetEntity = Survey_Info.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "surveyInfoId")
	private Survey_Info surveyInfo;
	
	@ManyToOne(targetEntity = SurveyReform.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "correctionId")
	private SurveyReform correction;

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public Survey_Info getSurveyInfo() {
		return surveyInfo;
	}

	public void setSurveyInfo(Survey_Info surveyInfo) {
		this.surveyInfo = surveyInfo;
	}

	public String getOssKey() {
		return ossKey;
	}

	public void setOssKey(String ossKey) {
		this.ossKey = ossKey;
	}

	public SurveyReform getCorrection() {
		return correction;
	}

	public void setCorrection(SurveyReform correction) {
		this.correction = correction;
	}

	public String getMediaId() {
		return mediaId;
	}

	public void setMediaId(String mediaId) {
		this.mediaId = mediaId;
	}
}
