package com.bcxin.survey.domain.survey;

import com.bcxin.survey.domain.BaseBean;
import com.bcxin.survey.domain.security.User;
import com.fasterxml.jackson.annotation.JsonBackReference;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import javax.persistence.*;
import java.util.Date;

/**
 * 查勘签到
 * @author bcxin
 *
 */
@Entity
@Table(name = "RISK_SURVEYSIGN")
@Proxy(proxyClass = SurveySign.class)
@Inheritance(strategy = InheritanceType.JOINED)
@DynamicInsert(true)
@DynamicUpdate(true)
public class SurveySign extends BaseBean{

	private static final long serialVersionUID = 1L;
		
	// 勘察员工号
	@ManyToOne(targetEntity = User.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "userId")
	@JsonBackReference
	private User user = new User();
	
	private double longitude;//经度
	
	private double latitude;//纬度
	
	private String planId;//勘查计划ID
	
	private Date signDate;//签到时间

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public double getLongitude() {
		return longitude;
	}

	public void setLongitude(double longitude) {
		this.longitude = longitude;
	}

	public double getLatitude() {
		return latitude;
	}

	public void setLatitude(double latitude) {
		this.latitude = latitude;
	}

	public Date getSignDate() {
		return signDate;
	}

	public void setSignDate(Date signDate) {
		this.signDate = signDate;
	}

	public String getPlanId() {
		return planId;
	}

	public void setPlanId(String planId) {
		this.planId = planId;
	}
	
	
}
