package com.bcxin.survey.domain.survey;

import com.bcxin.survey.domain.BaseBean;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.enums.report.AssignStatus;
import com.bcxin.survey.enums.report.AssignType;
import com.bcxin.survey.enums.report.SurveyStep;
import com.fasterxml.jackson.annotation.JsonBackReference;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import javax.persistence.*;

/**
 * 勘查协助（任务转交及申请专家）
 * @author Administrator
 *
 */
@Entity
@Table(name = "RISK_SurveyAssist")
@Proxy(proxyClass = SurveyAssist.class)
@Inheritance(strategy = InheritanceType.JOINED)
@DynamicInsert(true)
@DynamicUpdate(true)
public class SurveyAssist extends BaseBean{

	private static final long serialVersionUID = 1L;
	
	//任务编号
	@ManyToOne(targetEntity = SurveyTask.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "taskId")
	private SurveyTask surveyTask = new SurveyTask();
	
	// 勘察员工号
	@ManyToOne(targetEntity = User.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "userId")
	@JsonBackReference
	private User user = new User();
	
	//接收者
	@ManyToOne(targetEntity = User.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "accepterId")
	private User accepter = new User();
	
	@Enumerated(EnumType.STRING)
	private SurveyStep surveyStep;//查勘阶段
	
	private String experts;//申请的专家
	
	private String reason;//申请原因

	@Enumerated(EnumType.STRING)
	private AssignType assignType;//任务类型
	
	@Enumerated(EnumType.STRING)
	private AssignStatus assignStatus;//分配状态

	public SurveyTask getSurveyTask() {
		return surveyTask;
	}

	public void setSurveyTask(SurveyTask surveyTask) {
		this.surveyTask = surveyTask;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public User getAccepter() {
		return accepter;
	}

	public void setAccepter(User accepter) {
		this.accepter = accepter;
	}

	public SurveyStep getSurveyStep() {
		return surveyStep;
	}

	public void setSurveyStep(SurveyStep surveyStep) {
		this.surveyStep = surveyStep;
	}

	public String getReason() {
		return reason;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	public AssignType getAssignType() {
		return assignType;
	}

	public void setAssignType(AssignType assignType) {
		this.assignType = assignType;
	}

	public AssignStatus getAssignStatus() {
		return assignStatus;
	}

	public void setAssignStatus(AssignStatus assignStatus) {
		this.assignStatus = assignStatus;
	}

	public String getExperts() {
		return experts;
	}

	public void setExperts(String experts) {
		this.experts = experts;
	}
	
}
