package com.bcxin.survey.domain.activity;

import com.bcxin.survey.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.Date;

/**
 * 系统通知，站内信
* Copyright (c) 2016, pss360.cn All Rights Reserved.
* @Description: 
* @date: 2016年12月13日 上午11:10:51 
* @author Administrator
 */
@Entity
@Table(name = "RISK_Message")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class Message extends BaseBean {

	private static final long serialVersionUID = 1L;

	private Long user_id;//用户

	private String readStatus; //阅读状态（字典）

	private String title;

	private String content;

	private String keyword;

	@Temporal(TemporalType.TIMESTAMP)
	private Date readTime;

	private String url;

	private String checkFun; // 校验方法 (校验承办方是否改变了风评机构或第三方服务机构)
}
