package com.bcxin.survey.domain.activity;

import com.bcxin.survey.domain.BaseBean;
import com.bcxin.survey.domain.security.User;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 专家订单
 */
@Entity
@Table(name = "RISK_ExpertOrderForm")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@DynamicInsert(true)
@DynamicUpdate(true)
public class ExpertOrderForm extends BaseBean {

	private static final long serialVersionUID = 1L;
	
	@ManyToOne(targetEntity = User.class, fetch = FetchType.EAGER, cascade = CascadeType.PERSIST)
	@JoinColumn(name = "user_id")
	private User user;

	@OneToOne(targetEntity = OrderForm.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "orderForm_id")
	private OrderForm orderForm;//订单信息

	private String orderType;//订单类型 1：勘查 2：撰写

	private String step;

	private String isSync = "0"; // 业务支撑同步标志 0:未同步，1:同步 2：待确认

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public OrderForm getOrderForm() {
		return orderForm;
	}

	public void setOrderForm(OrderForm orderForm) {
		this.orderForm = orderForm;
	}

	public String getIsSync() {
		return isSync;
	}

	public void setIsSync(String isSync) {
		this.isSync = isSync;
	}

	public String getOrderType() {
		return orderType;
	}

	public void setOrderType(String orderType) {
		this.orderType = orderType;
	}

	public String getStep() {
		return step;
	}

	public void setStep(String step) {
		this.step = step;
	}
}
