package com.bcxin.survey.dao.venue;

import com.bcxin.survey.dao.report.BaseDaoImpl;
import com.bcxin.survey.domain.venue.VenueBase;
import com.bcxin.survey.dto.ComposeVenueSearchDto;
import com.bcxin.survey.utils.StringUtil;
import com.bcxin.survey.vo.DwzPage;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class VenueBaseDaoImpl extends BaseDaoImpl implements VenueBaseDao {

	@Override
	public List<VenueBase> queryVenueList(ComposeVenueSearchDto searchDto, DwzPage page){
		List<Criterion> criterionList = Lists.newArrayList();

		if(StringUtil.isNotEmpty(searchDto.getVenueType())) {
			criterionList.add(Restrictions.eq("venueType",searchDto.getVenueType()));
		}
		if(StringUtil.isNotEmpty(searchDto.getProvince())) {
			criterionList.add(Restrictions.eq("province",searchDto.getProvince()));
		}
		if(StringUtil.isNotEmpty(searchDto.getCity())) {
			criterionList.add(Restrictions.eq("city",searchDto.getCity()));
		}
		if(StringUtil.isNotEmpty(searchDto.getName())) {
			criterionList.add(Restrictions.like("name","%"+searchDto.getName()+"%"));
		}

		Disjunction dis = Restrictions.disjunction();
		Conjunction con = Restrictions.conjunction();
		dis.add(Restrictions.eq("nature","0"));

		con.add(Restrictions.eq("nature","1"));
		con.add(Restrictions.eq("userId",searchDto.getUserId()));
		dis.add(con);
		criterionList.add(dis);

		return findByCriterionForPage(VenueBase.class, criterionList, page);
	}

	@Override
	public VenueBase findVenue(VenueBase venueBase) {
		List<Criterion> criterionList = Lists.newArrayList();

		if(StringUtil.isNotEmpty(venueBase.getVenueType())) {
			criterionList.add(Restrictions.eq("venueType",venueBase.getVenueType()));
		}
		if(StringUtil.isNotEmpty(venueBase.getProvince())) {
			criterionList.add(Restrictions.eq("province",venueBase.getProvince()));
		}
		if(StringUtil.isNotEmpty(venueBase.getCity())) {
			criterionList.add(Restrictions.eq("city",venueBase.getCity()));
		}
		if(StringUtil.isNotEmpty(venueBase.getName())) {
			criterionList.add(Restrictions.like("name","%"+venueBase.getName()+"%"));
		}

		List<VenueBase> list = findByCriterion(VenueBase.class,criterionList);
		if(list != null && list.size() > 0){
			return list.get(0);
		}
		return null;
	}

	@Override
	public List<VenueBase> getVenueByType(ComposeVenueSearchDto searchDto) {
		List<Criterion> criterionList = Lists.newArrayList();

		if(searchDto.getUserId() != null) {
			criterionList.add(Restrictions.eq("userId",searchDto.getUserId()));
		}
		if(StringUtil.isNotEmpty(searchDto.getVenueType())) {
			criterionList.add(Restrictions.eq("venueType",searchDto.getVenueType()));
		}
		if(StringUtil.isNotEmpty(searchDto.getNature())) {
			criterionList.add(Restrictions.eq("nature",searchDto.getNature()));
		}

		return findByCriterion(VenueBase.class,criterionList);
	}

}
