package com.bcxin.survey.dao.report;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.bcxin.survey.domain.data.MaterialTask;
import com.bcxin.survey.utils.DictConst;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Repository
public class MaterialTaskDaoImpl extends BaseDaoImpl implements MaterialTaskDao {

    @Override
    public MaterialTask findMaterialTaskByOid(Long oid){
        return findByCriterionToUnique(MaterialTask.class, Restrictions.eq("oid", oid));
    }

    @Override
    public List<MaterialTask> findUnCompleteTask(){
        List<Criterion> criterionList = new ArrayList<Criterion>();
        criterionList.add(Restrictions.eq("success", DictConst.N));
        /* 取30分钟之前的，防止正在同步的任务重复同步 */
        DateTime offsetDate = DateUtil.offsetMinute(new Date(), -30);
        criterionList.add(Restrictions.lt("createOn", offsetDate));
//        criterionList.add(Restrictions.lt("createOn", DateUtil.format(offsetDate,"yyyy-MM-dd HH:mm:ss")));
        return 	findByCriterion(MaterialTask.class, criterionList);
    }

}
