package com.bcxin.survey.controller.wechat;

import com.bcxin.survey.base.BaseController;
import com.bcxin.survey.domain.activity.Activity;
import com.bcxin.survey.domain.activity.ActivityVenue;
import com.bcxin.survey.domain.activity.Venue;
import com.bcxin.survey.domain.report.Task;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.SurveyPlan;
import com.bcxin.survey.domain.survey.SurveyTask;
import com.bcxin.survey.enums.report.PlanStatusEnum;
import com.bcxin.survey.enums.report.SurveyStep;
import com.bcxin.survey.enums.report.SurveyTaskStatus;
import com.bcxin.survey.service.CommonService;
import com.bcxin.survey.service.UserService;
import com.bcxin.survey.service.report.ActivityService;
import com.bcxin.survey.service.report.TaskService;
import com.bcxin.survey.service.wechat.SurveyFeedBackService;
import com.bcxin.survey.service.wechat.SurveyPlanService;
import com.bcxin.survey.service.wechat.SurveyTaskService;
import com.bcxin.survey.utils.DateUtil;
import com.bcxin.survey.utils.StringUtil;
import com.bcxin.survey.utils.SurveyManagerUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Controller
@RequestMapping("/wechat/plan")
public class WechatPlanController extends BaseController {

	@Autowired
	private UserService userService;
	@Autowired
	private CommonService commonService;
		
	@Autowired
	private SurveyTaskService surveyTaskService;
		
	@Autowired
	private SurveyPlanService surveyPlanService;
	
	@Autowired
	private SurveyFeedBackService surveyFeedBackService;
	
	@Autowired
	private ActivityService activityService;

	@Autowired
	private SurveyManagerUtil surveyManagerUtil;

	@Autowired
	private TaskService taskService;
		
	@org.springframework.web.bind.annotation.InitBinder
	public void InitBinder(WebDataBinder dataBinder) {
		dataBinder.registerCustomEditor(Date.class, new CustomDateEditor(new SimpleDateFormat("yyyy-MM-dd HH:mm"), true)); 
	}

	/**
	 * 我的日程 页面初始化
	 * @return
	 */
	@RequestMapping("surveyPlan/init")
	public ModelAndView surveyPlanInit(HttpServletRequest request){
		ModelAndView view = new ModelAndView("wechat/plan/surveyPlan");
//		User user = userService.findUserByCode(request,view);
		User user = (User) userService.getCurrentUser();
		if(user != null ){	
			view.addObject("user", user);
			view.addObject("taskList",surveyTaskService.findUnFinishedSurveyTaskListByUser(user));
			view.addObject("stepList",SurveyStep.values());
		}
		return view;
	}
	
	/**
	 * 计划列表
	 * @param taskId
	 * @return
	 */
	@RequestMapping("planList/init")
	public ModelAndView planListInit(long taskId){
		ModelAndView view = new ModelAndView("wechat/plan/planList");
		User user = (User) userService.getCurrentUser();
		if(user != null){
			view.addObject("user", user);
			SurveyTask surveyTask = surveyTaskService.findSurveyTaskByOid(taskId);
			if(surveyTask.getActivity()!=null){
				Activity activity=surveyTask.getActivity();
				surveyTask.setAddress(activity.getAddress());
				surveyTask.setContacts(activity.getSponsor());
				surveyTask.setName(activity.getName());
				surveyTask.setActivityTime(DateUtil.convertStringToDate(activity.getStartDate()));
				surveyTask.setEndTime(DateUtil.convertStringToDate(activity.getEndDate()));
			}

			boolean showExpertBtn=true;
			Integer count = surveyTaskService.selectStepExpert(surveyTask.getTask().getOid());
			if (count == 3) {
				showExpertBtn=false;
			}
			view.addObject("showExpertBtn", showExpertBtn);

			List<ActivityVenue> list = activityService.findActivityVenuesByActivity(surveyTask.getActivity());
			List<Venue> venues = new ArrayList<Venue>();
			for (ActivityVenue activityVenue : list) {
				venues.add(activityVenue.getVenue());
			}
			
			Date nowDate = new Date();
			boolean showBtn = true;
			if(nowDate.getTime() > surveyTask.getEndTime().getTime()) {
				showBtn = false;
			}
			view.addObject("showBtn",showBtn);
			view.addObject("task",surveyTask);
			view.addObject("expertName",surveyTaskService.selectStepExpertName(surveyTask.getTask().getOid()));
			view.addObject("stepList",SurveyStep.values());
			view.addObject("addressList", venues);
//			List<SurveyPlan> list1=surveyPlanService.findSurveyPlanByTaskId(taskId);
//			view.addObject("planList",surveyPlanService.findSurveyPlanByTaskId(taskId));
			view.addObject("planList",surveyPlanService.findSurveyPlanBySurveyTaskId(taskId));
			view.addObject("expertSource",commonService.getExpertSource(user.getOid()));
		}
		return view;
	}
	
	@RequestMapping("/addPlan/init")
	public ModelAndView addPlanInit(@RequestParam(required = false) String taskId,HttpServletRequest request){
		ModelAndView view = new ModelAndView("wechat/plan/editPlan");
		User user = userService.getCurrentUser();
		if(StringUtil.isNotEmpty(taskId)){
			SurveyTask surveyTask = surveyTaskService.findSurveyTaskByOid(Long.parseLong(taskId));
			Task task = taskService.findTaskByOid(surveyTask.getTask().getOid());
			int leve = task.getTKConfigLeve();
			System.out.println(surveyTask.getActivity().getOid());
			List<ActivityVenue> list = activityService.findActivityVenuesByActivity(surveyTask.getActivity());
			List<Venue> venues = new ArrayList<Venue>();
			for (ActivityVenue activityVenue : list) {
				venues.add(activityVenue.getVenue());
			}
			view.addObject("stepList",SurveyStep.leveConvert(leve));
			view.addObject("surveyTask",surveyTask);
			view.addObject("addressList", venues);
			view.addObject("planList",surveyPlanService.findSurveyPlanByTaskId(surveyTask.getOid()));
		}else{
			view.addObject("taskList",surveyTaskService.findUnFinishedSurveyTaskListByUser(user));
			String start = request.getParameter("start");
			view.addObject("start",StringUtil.isNotEmpty(start) ? DateUtil.convertStringToDate(start.replace("—", " ")):"");
			String end = request.getParameter("end");
			view.addObject("end",StringUtil.isNotEmpty(end) ? DateUtil.convertStringToDate(end.replace("—", " ")):"");
			view.addObject("stepList",SurveyStep.values());
		}
		return view;
	}

	@RequestMapping("/editPlan/init/{planId}")
	public ModelAndView editPlanInit(@PathVariable long planId){
		ModelAndView view = new ModelAndView("wechat/plan/editPlan");
		SurveyPlan surveyPlan = surveyPlanService.findSurveyPlanByOid(planId);
		SurveyTask surveyTask = surveyPlan.getSurveyTask();
		Task task = taskService.findTaskByOid(surveyTask.getTask().getOid());
		
		List<ActivityVenue> list = activityService.findActivityVenuesByActivity(surveyTask.getActivity());
		List<Venue> venues = new ArrayList<Venue>();
		for (ActivityVenue activityVenue : list) {
			venues.add(activityVenue.getVenue());
		}

		// 获取该阶段的踏勘专家
		String tkExpert= surveyTaskService.selectStepExpertName(surveyTask.getTask().getOid(),surveyPlan.getSurveyStep().toString());
		view.addObject("tkExpert",tkExpert);
		view.addObject("surveyTask",surveyTask);
		view.addObject("stepList",SurveyStep.leveConvert(task.getTKConfigLeve()));
		view.addObject("addressList", venues);
		view.addObject("planList",surveyPlanService.findSurveyPlanByTaskId(surveyTask.getOid()));
		view.addObject("surveyPlan",surveyPlan);
		return view;
	}
	
	/**
	 * 编辑勘查计划
	 * @param surveyPlan
	 * @return
	 */
	@RequestMapping("editSurveyPlan")
	public JSONObject editSurveyPlan(SurveyPlan surveyPlan){
		User user = (User) userService.getCurrentUser();
		surveyPlan.setUser(user);
		return surveyPlanService.editSurveyPlan(surveyPlan);
	}
	
	/**
	 * 获取计划列表 for 我的日程
	 * @param beginTime
	 * @param endTime
	 * @return
	 */
	@RequestMapping("getSurveyPlan")
	public JSONObject getSurveyPlan(Date beginTime,Date endTime){
		User user = (User) userService.getCurrentUser();
		JSONObject obj = new JSONObject();
		JSONArray planArr = new JSONArray();
		List<SurveyPlan> surveyPlans = surveyPlanService.findSurveyPlanListByUserAndDate(user, beginTime, endTime);
		for (SurveyPlan surveyPlan : surveyPlans) {
			JSONObject plan = new JSONObject();
			plan.put("id", surveyPlan.getOid());
			String title = surveyPlan.getSurveyTask().getName() +"\r\n第"+ surveyPlan.getTime()+"次勘查";
			title = title + "\r\n" + surveyPlan.getSurveyStep().getName();
			if(surveyPlan.getVenue() != null){
				title = title + "\r\n场地：" + surveyPlan.getVenue().getName();
			}
			if(StringUtil.isNotEmpty(surveyPlan.getRemark())){
				title = title + "\r\n备注：" + surveyPlan.getRemark();
			}
//			if(surveyPlan.getTaskStatus().equals(TaskStatus.CLOSE) || surveyPlan.getTaskStatus().equals(TaskStatus.COMPLETE)) {
//				title = title + "(" + surveyPlan.getTaskStatus().getName() + ")";
//			}
			if(surveyPlan.getTaskStatus().equals(PlanStatusEnum.CLOSE) || surveyPlan.getTaskStatus().equals(PlanStatusEnum.COMPLETE)) {
				title = title + "(" + surveyPlan.getTaskStatus().getAlias() + ")";
			}


			plan.put("title", title);
			plan.put("start",DateUtil.convertDateToString(surveyPlan.getBeginTime(),DateUtil.FORMAT1));
			plan.put("end", DateUtil.convertDateToString(surveyPlan.getEndTime(), DateUtil.FORMAT1));
			plan.put("allDay", surveyPlan.isAllDay());
			plan.put("taskName", surveyPlan.getSurveyTask().getName());
			plan.put("taskId", surveyPlan.getSurveyTask().getOid());
			plan.put("surveyStep", surveyPlan.getSurveyStep().toString());
			if(surveyPlan.getVenue() != null) {
				plan.put("cmsAddress", surveyPlan.getVenue().getOid());
			}else {
				plan.put("cmsAddress", "");
			}
			plan.put("time", surveyPlan.getTime());
			if(!surveyPlan.getSurveyTask().getSurveyTaskStatus().equals(SurveyTaskStatus.DOING)) {
				plan.put("taskStatus", surveyPlan.getSurveyTask().getSurveyTaskStatus());
			}else {
				plan.put("taskStatus", surveyPlan.getTaskStatus());
			}
			plan.put("remark",surveyPlan.getRemark());
			planArr.add(plan);
		}
		obj.put("events", planArr);
		return obj;
	}

	//获取新的计划次数
	@RequestMapping("getPlanTimeByTaskId")
	public JSONObject getPlanTimeByTaskId(long taskId){
		List<SurveyPlan> planList = surveyPlanService.findSurveyPlanByTaskId(taskId);
		JSONObject json = new JSONObject();
		JSONArray arr = new JSONArray();
		json.put("time", planList.size()+1);
		
		SurveyTask surveyTask = surveyTaskService.findSurveyTaskByOid(taskId);
		List<ActivityVenue> list = activityService.findActivityVenuesByActivity(surveyTask.getActivity());
		for (ActivityVenue activityVenue : list) {
			JSONObject obj = new JSONObject();
			obj.put("addressId", activityVenue.getVenue().getOid());
			obj.put("address", activityVenue.getVenue().getName());
			arr.add(obj);
		}
		json.put("addressList",arr);
		return json;
	}
	
	/**
	 * 删除计划
	 * @param planId
	 * @return
	 */
	@RequestMapping("deleteSurveyPlan")
	public JSONObject deleteSurveyPlan(long planId){		
		JSONObject obj = new JSONObject();
		SurveyPlan plan = surveyPlanService.findSurveyPlanByOid(planId);
		SurveyTask surveyTask = plan.getSurveyTask();
		String statusCode ="300";
		String message ="";
		if(surveyPlanService.delete(plan)){
			surveyPlanService.planListForSort(surveyTask.getOid());
			statusCode="200";
			message ="删除成功";
			surveyFeedBackService.checkFeedBackStatusByFeedBackId(plan.getFeedBack().getOid());
			obj.put("taskId",surveyTask.getOid());
		}else{
			message ="删除失败";
		}
		obj.put("statusCode", statusCode);
		obj.put("message", message);
		return obj;
	}
	
	/**
	 * 获取计划详情
	 * @param planId
	 * @return
	 */
	@RequestMapping("getPlanDetail")
	public JSONObject getPlanDetail(long planId){
		SurveyPlan plan = surveyPlanService.findSurveyPlanByOid(planId);
		JSONObject json = new JSONObject();

		String startDate = "";
		String endDate = "";
		if(plan.getBeginTime() != null) {
			startDate = DateUtil.convertDateToString(plan.getBeginTime(), DateUtil.FORMAT1);
		}
		if(plan.getEndTime() != null) {
			endDate = DateUtil.convertDateToString(plan.getEndTime(), DateUtil.FORMAT1);
		}
		
		json.put("allDay", plan.isAllDay());
		json.put("startDate", startDate);
		json.put("endDate", endDate);
		json.put("surveyStep", plan.getSurveyStep().toString());
		json.put("time", plan.getTime());
		return json;
	}
	
	/**
	 * 查看分配的专家信息
	 * @param planId
	 * @return
	 */
	@RequestMapping("getExpertsByPlanId")
	public JSONObject getExpertsByPlanId(long planId){
		SurveyPlan plan = surveyPlanService.findSurveyPlanByOid(planId);
		JSONObject json = new JSONObject();
		String status="300";
		JSONArray expertArr = new JSONArray();
		if(plan != null && plan.getFeedBack().getExperts().size() > 0){
			for(User expert : plan.getFeedBack().getExperts()){
				JSONObject expertObj = new JSONObject();
				expertObj.put("name", expert.getRealName());
				expertObj.put("mobile", StringUtil.isEmpty(expert.getPhone())? "":expert.getPhone());
				expertArr.add(expertObj);
			}
			status="200";
		}
		json.put("status", status);
		json.put("experts", expertArr);
		return json;
	}

	@RequestMapping("getExpertsByTaskId")
	@ResponseBody
	public JSONObject showExpert(Long surveyTaskId,String surveyStep){
		SurveyTask surveyTask=surveyTaskService.findSurveyTaskByOid(surveyTaskId);
		String tkExpert= surveyTaskService.selectStepExpertName(surveyTask.getTask().getOid(),surveyStep);
		JSONObject json = new JSONObject();
		json.put("status", "200");
		json.put("tkExpert", tkExpert);
		return json;
	}
	
	
}
