package com.bcxin.risk.sys;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.risk.common.dao.MarketRegionDao;
import com.bcxin.risk.common.domain.MarketRegion;
import com.bcxin.risk.constant.DictConst;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 可销售城市地区类
 */
@Service
@Slf4j
public class SysMarketRegionUtil {

    @Resource
    private MarketRegionDao marketRegionDao ;

    private static List<MarketRegion> CACHE_KEY_MARKET_REGION_PROVINCE = Lists.newArrayList();

    private static List<MarketRegion> CACHE_KEY_MARKET_REGION_CITY = Lists.newArrayList();

    private static List<MarketRegion> CACHE_KEY_MARKET_REGION_AREA = Lists.newArrayList();

    private static List<Long> CACHE_KEY_MARKET_REGION_ID_PROVINCE = Lists.newArrayList();

    private static List<Long> CACHE_KEY_MARKET_REGION_ID_CITY = Lists.newArrayList();

    private static List<Long> CACHE_KEY_MARKET_REGION_ID_AREA = Lists.newArrayList();

    /**
     * 查询可销售区域
     */
    public List<MarketRegion> findRegionByLevel(String level){
        if (DictConst.REGIONLEVEL_PROVINCE.equals(level)) {
            if (CollectionUtil.isNotEmpty(CACHE_KEY_MARKET_REGION_PROVINCE)) {
                return CACHE_KEY_MARKET_REGION_PROVINCE;
            }
        } else if (DictConst.REGIONLEVEL_CITY.equals(level)){
            if (CollectionUtil.isNotEmpty(CACHE_KEY_MARKET_REGION_CITY)) {
                return CACHE_KEY_MARKET_REGION_CITY;
            }
        } else if (DictConst.REGIONLEVEL_AREA.equals(level)){
            if (CollectionUtil.isNotEmpty(CACHE_KEY_MARKET_REGION_AREA)) {
                return CACHE_KEY_MARKET_REGION_AREA;
            }
        }
        List<MarketRegion> rList = marketRegionDao.findRegionByLevel(level);
        if (DictConst.REGIONLEVEL_PROVINCE.equals(level)) {
            CACHE_KEY_MARKET_REGION_PROVINCE = rList;
        } else if (DictConst.REGIONLEVEL_CITY.equals(level)){
            CACHE_KEY_MARKET_REGION_CITY = rList;
        } else if (DictConst.REGIONLEVEL_AREA.equals(level)){
            CACHE_KEY_MARKET_REGION_AREA = rList;
        }
        return rList;
    }

    /**
     * 查询可销售区域
     */
    public List<Long> findRegionIdByLevel(String level){
        if (DictConst.REGIONLEVEL_PROVINCE.equals(level)) {
            if (CollectionUtil.isNotEmpty(CACHE_KEY_MARKET_REGION_ID_PROVINCE)) {
                return CACHE_KEY_MARKET_REGION_ID_PROVINCE;
            }
        } else if (DictConst.REGIONLEVEL_CITY.equals(level)){
            if (CollectionUtil.isNotEmpty(CACHE_KEY_MARKET_REGION_ID_CITY)) {
                return CACHE_KEY_MARKET_REGION_ID_CITY;
            }
        } else if (DictConst.REGIONLEVEL_AREA.equals(level)){
            if (CollectionUtil.isNotEmpty(CACHE_KEY_MARKET_REGION_ID_AREA)) {
                return CACHE_KEY_MARKET_REGION_ID_AREA;
            }
        }
        List<MarketRegion> rList = marketRegionDao.findRegionByLevel(level);
        List<Long> ridList = Lists.newArrayList();
        for (MarketRegion marketRegion : rList) {
            ridList.add(marketRegion.getOid());
        }
        if (DictConst.REGIONLEVEL_PROVINCE.equals(level)) {
            CACHE_KEY_MARKET_REGION_ID_PROVINCE = ridList;
        } else if (DictConst.REGIONLEVEL_CITY.equals(level)){
            CACHE_KEY_MARKET_REGION_ID_CITY = ridList;
        } else if (DictConst.REGIONLEVEL_AREA.equals(level)){
            CACHE_KEY_MARKET_REGION_ID_AREA = ridList;
        }
        return ridList;
    }

}
