package com.bcxin.risk.sys;

import cn.hutool.core.map.MapUtil;
import com.bcxin.risk.common.dao.DictDao;
import com.bcxin.risk.common.domain.Dict;
import com.bcxin.risk.common.mapper.JsonMapper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 字典工具类
 * @author luopeng
 */
@Service
@Transactional
public class SysDictUtil {

	@Resource
	private DictDao dictDao;

	private Map<String,Collection<Dict>>  CACHE_KEY_DICT = Maps.newHashMap();

	public String getDictLabel(String value, String type, String defaultValue){
		if (StringUtils.isNotBlank(type) && StringUtils.isNotBlank(value)){
			Collection<Dict> list = dictMap().get(type.toUpperCase());
			for (Dict dict : list){
				if (value.equals(dict.getValue())){
					return dict.getLabel();
				}
			}
		}
		return defaultValue;
	}

	public String getDictValue(String label, String type, String defaultLabel){
		if (StringUtils.isNotBlank(type) && StringUtils.isNotBlank(label)){
			Collection<Dict> list = dictMap().get(type.toUpperCase());
			for (Dict dict : list){
				if (label.equals(dict.getLabel())){
					return dict.getValue();
				}
			}
		}
		return defaultLabel;
	}
	
	public Collection<Dict> getDictList(String type){
		return dictMap().get(type.toUpperCase()); //因为数据字典类型均为大写
	}

	/**
	 * 获取dictList
	 * @return
	 */
	private Map<String,Collection<Dict>> dictMap(){
		if (MapUtil.isNotEmpty(CACHE_KEY_DICT)) {
			return CACHE_KEY_DICT;
		}
		List<Dict> dictList = dictDao.selectDictList();
		Multimap<String, Dict> map = ArrayListMultimap.create();
		for(Dict dict: dictList){
			map.put(dict.getType().toUpperCase(),dict);
		}
		CACHE_KEY_DICT = map.asMap();
		return CACHE_KEY_DICT;
	}

	/**
	 * 返回字典列表（JSON）
	 * @param type
	 * @return
	 */
	public String getDictListJson(String type){
		return JsonMapper.toJsonString(getDictList(type.toUpperCase()));
	}
	
}
