package com.bcxin.risk.common.util;

import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

public class WebUtil {
	
    /**
     * 取得request中所有的参数名
     *
     * @param request
     * @return
     */
    public static List<String> getRequestParamNames(HttpServletRequest request) {

        Enumeration<String> paramNameEnum = request.getParameterNames();
        List<String> result = new ArrayList<String>();

        //先将Enumeration中参数转成LIST
        while (paramNameEnum.hasMoreElements()) {
            result.add(paramNameEnum.nextElement().trim());
        }

        return result;
    }

    /**
     * 取得请求中的所有参数的键值对
     * add by chenmk 2009.12.25
     *
     * @param request
     * @return
     */
    public static Map<String, String> getParameterMap(HttpServletRequest request) {
        List<String> paramNameList = getRequestParamNames(request);

        Map<String, String> result = new HashMap<String, String>();

        if (paramNameList == null || paramNameList.size() == 0) {
            return result;
        }

        for(String paramName : paramNameList){
            result.put(paramName, request.getParameter(paramName));
        }

        return result;
    }



    /**
     * 增加一个cookie
     * add by wenjg 2009-11-25
     * @param cookie
     */
    public static void addCookie(HttpServletResponse response, Cookie cookie) {
    	response.addCookie(cookie);
    }



    /**
     * 读取ip
     * @param request
     * @return
     */
    public static String getIp(HttpServletRequest request){
        String ip = request.getHeader("X-Forwarded-For");
        if(StringUtils.isNotEmpty(ip) && !"unKnown".equalsIgnoreCase(ip)){
            //多次反向代理后会有多个ip值，第一个ip才是真实ip
            int index = ip.indexOf(",");
            if(index != -1){
                return ip.substring(0,index);
            }else{
                return ip;
            }
        }
        ip = request.getHeader("X-Real-IP");
        if(StringUtils.isNotEmpty(ip) && !"unKnown".equalsIgnoreCase(ip)){
            return ip;
        }
        return request.getRemoteAddr();
    }

    /**
     * 是否是Ajax异步请求
     */
    public static boolean isAjaxRequest(HttpServletRequest request){
        String accept = request.getHeader("accept");
        if (accept != null && accept.indexOf("application/json") != -1) {
            return true;
        }
        String xRequestedWith = request.getHeader("X-Requested-With");
        if (xRequestedWith != null && xRequestedWith.indexOf("XMLHttpRequest") != -1) {
            return true;
        }
        return false;
    }


}
