package com.bcxin.risk.common.util.compose;

import java.io.*;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 文件处理类
 * @author Ethan_Huang
 */
public class FileUtil {
	
	/**
	 * 根据日期生成文件名字符串
	 * @return
	 */
	public static String generatingFileNameByDate(String fileName) {
		Date date = new Date();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String str = sdf.format(date);
		return fileName + "_" + str;
	}

	/**
	 * 获取文件名后缀名
	 * @param fileName
	 * @return
	 */
	public static String getFileExtension(String fileName) {
		if (!fileName.isEmpty()) {
			return fileName.substring(fileName.lastIndexOf(".")+1);
		}
		return null;
	}
	
	/**
	 * 删除文件或文件夹
	 * @param filePath
	 */
	public static void deleteFolder(String filePath) {
		File file = new File(filePath);
		if(file.exists()) {
			if(file.isDirectory()) {
				for(File f : file.listFiles()) {
					deleteFolder(f.getAbsolutePath());
				}
				file.delete();
			} else {
				System.out.println(file.delete());
			}
		}
	}
	
	/**
	 * 递归删除文件
	 * @param folder
	 * @param d
	 */
	public static void deleteFile(File folder, Date d) {
		File[] files = folder.listFiles();
		for(File f : files) {
			if(f.isDirectory()) {
				deleteFile(f, d);
				if(f.list().length == 0) {
					f.delete();
				}
			} else {
				if(f.lastModified() < d.getTime()) {
					f.delete();
				}
			}
		}
	}
	
	/**
	 * 复制文件夹
	 */
	public static void copyFolder(File resFile, File objFolderFile) throws IOException { 
        if (!resFile.exists()) return; 
        if (!objFolderFile.exists()) objFolderFile.mkdirs(); 
        if (resFile.isFile()) { 
            File objFile = new File(objFolderFile.getPath() + File.separator + resFile.getName()); 
            //复制文件到目标地 
            InputStream ins = new FileInputStream(resFile); 
            FileOutputStream outs = new FileOutputStream(objFile); 
            byte[] buffer = new byte[1024 * 512]; 
            int length; 
            while ((length = ins.read(buffer)) != -1) { 
                outs.write(buffer, 0, length); 
            } 
            ins.close(); 
            outs.flush(); 
            outs.close(); 
        } else { 
            String objFolder = objFolderFile.getPath() + File.separator + resFile.getName(); 
            File _objFolderFile = new File(objFolder); 
            _objFolderFile.mkdirs(); 
            for (File sf : resFile.listFiles()) { 
            	copyFolder(sf, new File(objFolder)); 
            } 
        } 
	}
	
	/**
	 * 根据文件获取byte数组
	 * @param filePath
	 * @return
	 */
	public static byte[] getBytes(String filePath){  
        byte[] buffer = null;  
        try {  
            File file = new File(filePath);  
            FileInputStream fis = new FileInputStream(file);  
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);  
            byte[] b = new byte[1000];  
            int n;  
            while ((n = fis.read(b)) != -1) {  
                bos.write(b, 0, n);  
            }  
            fis.close();  
            bos.close();  
            buffer = bos.toByteArray();  
        } catch (FileNotFoundException e) {  
            e.printStackTrace();  
        } catch (IOException e) {  
            e.printStackTrace();  
        }  
        return buffer;  
    }
	
	/**
	 * 根据byte生成文件
	 * @param bfile
	 * @param filePath
	 * @param fileName
	 */
	public static void getFile(byte[] bytes, String filePath,String fileName) {  
        BufferedOutputStream bos = null;  
        FileOutputStream fos = null;  
        File file = null;  
        try {  
            File dir = new File(filePath);  
            if(!dir.exists()&&dir.isDirectory()){//判断文件目录是否存在  
                dir.mkdirs();  
            }  
            file = new File(filePath+"\\"+fileName);  
            fos = new FileOutputStream(file);  
            bos = new BufferedOutputStream(fos);  
            bos.write(bytes);  
        } catch (Exception e) {  
            e.printStackTrace();  
        } finally {  
            if (bos != null) {  
                try {  
                    bos.close();  
                } catch (IOException e1) {  
                    e1.printStackTrace();  
                }  
            }  
            if (fos != null) {  
                try {  
                    fos.close();  
                } catch (IOException e1) {  
                    e1.printStackTrace();  
                }  
            }  
        }  
    }
	
}