/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util.sms;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.risk.common.util.ConfigUtil;
import com.bcxin.risk.common.util.HttpUtil;
import com.bcxin.risk.common.util.cipher.MD5Util;
import com.bcxin.risk.common.util.sms.HuaWeiSmsContent;
import com.bcxin.risk.common.util.sms.RequestUtil;
import com.bcxin.risk.sys.resources.ConfigResources;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Future;
import lombok.Generated;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;

@Component
public class SMSUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SMSUtil.class);
    private static final String KEY = "bcxinABCXIN$1012 ";
    private static final String CHANNEL = "pss";

    @Async
    public Future<Boolean> sendSMS(String to, String content) {
        String envi = ConfigResources.PROFILE_ENVI;
        if (Objects.equals(envi, "dev") || Objects.equals(envi, "test")) {
            return new AsyncResult((Object)false);
        }
        String url = ConfigUtil.getValue("sms_url");
        String requestId = System.currentTimeMillis() + "";
        JSONObject json = new JSONObject();
        json.put("type", (Object)CHANNEL);
        json.put("content", (Object)content);
        json.put("mobile", (Object)to);
        json.put("requestId", (Object)requestId);
        json.put("token", (Object)MD5Util.string2MD5(requestId + CHANNEL + KEY));
        try {
            String ret = RequestUtil.initHttp().doPost(url, json.toString(), "application/json", "UTF-8");
            JSONObject retJson = JSONObject.parseObject((String)ret);
            if (retJson.get((Object)"status").equals("200")) {
                log.debug("\u77ed\u4fe1\u53d1\u9001\u6210\u529f\uff0c\u624b\u673a\u53f7\uff1a[{}]\uff0c\u77ed\u4fe1\u5185\u5bb9\uff1a[{}]", (Object)to, (Object)content);
                return new AsyncResult((Object)true);
            }
            log.error("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u624b\u673a\u53f7\uff1a[{}]\uff0c\u77ed\u4fe1\u5185\u5bb9\uff1a[{}]", (Object)to, (Object)content);
            return new AsyncResult((Object)false);
        }
        catch (Exception ex) {
            log.error("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u624b\u673a\u53f7\uff1a[{}]\uff0c\u77ed\u4fe1\u5185\u5bb9\uff1a[{}]", (Object)to, (Object)content);
            return new AsyncResult((Object)false);
        }
    }

    @Async
    public Future<Boolean> sendHuaWeiSMS(HuaWeiSmsContent huaWeiSmsContent) {
        String envi = ConfigResources.PROFILE_ENVI;
        if (Objects.equals(envi, "dev") || Objects.equals(envi, "test")) {
            return new AsyncResult((Object)false);
        }
        String url = ConfigUtil.getValue("sms_huawei_url");
        ArrayList params = Lists.newArrayList();
        params.add(new BasicNameValuePair("data", JSON.toJSONString((Object)huaWeiSmsContent)));
        params.add(new BasicNameValuePair("token", MD5Util.string2MD5("BCXIN" + huaWeiSmsContent.getMobile() + DateUtil.today())));
        HttpUtil.sendPostRequest(url, params);
        log.debug("\u77ed\u4fe1\u53d1\u9001\u6210\u529f\uff0c\u624b\u673a\u53f7\uff1a[{}]\uff0c\u77ed\u4fe1\u5185\u5bb9\uff1a[{}]", (Object)huaWeiSmsContent.getMobile(), (Object)huaWeiSmsContent.getParams());
        return new AsyncResult((Object)true);
    }

    public static void main(String[] args) {
        HuaWeiSmsContent huawei = new HuaWeiSmsContent();
        huawei.setParams(JSON.toJSONString((Object)new String[]{"837232"}));
        huawei.setPlatform("BCXIN");
        huawei.setSmsCode("P01");
        huawei.setMobile("18910027675");
        String url = "http://msg.bcxin.com.cn:9165/sms/huawei/sendSMS";
        ArrayList params = Lists.newArrayList();
        params.add(new BasicNameValuePair("data", JSON.toJSONString((Object)huawei)));
        params.add(new BasicNameValuePair("token", MD5Util.string2MD5("BCXIN18910027675" + DateUtil.today())));
        String aa = HttpUtil.sendPostRequest(url, params);
        System.out.println(aa);
    }
}

