package com.bcxin.risk.report.material;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.dao.QueryHelper;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.report.material.dao.MaterialFormAttrDao;
import com.bcxin.risk.report.material.domain.MaterialFormAttr;
import com.bcxin.risk.report.material.domain.MaterialFormMenu;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public class MaterialFormAttrDaoImpl extends DaoImpl<MaterialFormAttr> implements MaterialFormAttrDao {

	@Override
	public List<MaterialFormAttr> findByMenu(MaterialFormMenu materialFormMenu) {
		List<Criterion> criterionList = Lists.newArrayList();
		criterionList.add(Restrictions.eq("materialFormMenu",materialFormMenu));
        Order order = Order.asc("seq");
		List list  =  selectList(criterionList,order);
		if(list.size()>0){
			return list ;
		}
        return null ;
	}

	@Override
	public List<MaterialFormAttr> findMultiByMenu(MaterialFormMenu materialFormMenu) {
		List<Criterion> criterionList = Lists.newArrayList();
		criterionList.add(Restrictions.eq("materialFormMenu",materialFormMenu));
		criterionList.add(Restrictions.ne("mainEle", DictConst.Y));
		Order order = Order.asc("seq");
		List list  =  selectList(criterionList,order);
		if(list.size()>0){
			return list ;
		}
		return null ;
	}

	@Override
	public MaterialFormAttr findByMenuAttrCode(MaterialFormMenu materialFormMenu,String attrCode) {
		List<Criterion> criterionList = Lists.newArrayList();
		criterionList.add(Restrictions.eq("materialFormMenu",materialFormMenu));
		criterionList.add(Restrictions.eq("attrCode",attrCode));
		List<MaterialFormAttr> list  = selectList(criterionList);
		if(list.size()>0){
			return list.get(0) ;
		}
		return null ;
	}

	@Override
	public List<MaterialFormAttr> findByAttrCodes(String[] attrCodes, Activity activity) {
		SelectWrapper wrapper = SelectWrapper.instance();
		wrapper.in("attrCode",attrCodes);
		wrapper.in("activity_id",activity.getOid()+"");
		return selectList(wrapper);
	}


	@Override
	public MaterialFormAttr findByAttrCode(String attrCode, Activity activity) {
		List<Criterion> criterionList = Lists.newArrayList();
		criterionList.add(Restrictions.eq("activity",activity));
		criterionList.add(Restrictions.eq("attrCode",attrCode));
		return selectOne(criterionList);
	}

	@Override
	public List<MaterialFormAttr> findByActivity(Activity activity) {
		List<Criterion> criterionList = Lists.newArrayList();
		criterionList.add(Restrictions.eq("activity",activity));
		return selectList(criterionList);
	}

	/**
	 * 快速修复script脚本，请谨慎调用
	 * @param value
	 * @param attrCode
	 */
	@Override
	public void updateScript(String value,String attrCode){
		Map<String,Object> params = Maps.newHashMap();
		params.put("script",value);
		params.put("attrCode",attrCode);
		QueryHelper.executeSql("update risk_materialformattr set script = :script , updateOn = SYSDATE() where attrCode = :attrCode ",params);

		QueryHelper.executeSql("update config_materialformattrtemplate set script = :script , updateOn = SYSDATE() where attrCode = :attrCode ",params);
	}

	/**
	 * 快速查看带有script脚本的元素，请谨慎调用
	 */
	@Override
	public List<Map<String, Object>> selectScriptEle(){
		String sql = "select attrCode,script from config_materialformattrtemplate where script !='' and events != ''";
		List<Map<String, Object>> result = queryMaps(sql);
		return result;
	}

	@Override
	public void deleteByActivityId(Long activityId){
		String sql = "delete from risk_materialformattr where activity_id = " + activityId;
		this.executeSqlUpdate(sql);
	}
}
