package com.bcxin.risk.org;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.org.domain.ContractorOrg;
import com.bcxin.risk.org.domain.ContractorOrgDao;
import com.bcxin.risk.org.dto.ContractorOrgSerachDto;
import com.bcxin.risk.org.dto.OrgDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository("contractorOrgDao")
@SuppressWarnings("unchecked")

public class ContractorOrgDaoImpl extends DaoImpl<ContractorOrg> implements ContractorOrgDao {

    @Override
    public ContractorOrg findContractorOrgByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<ContractorOrg> findContractorOrgList(ContractorOrgSerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty(searchDto.getDescription()) ) {
            criterionList.add(Restrictions.eq("description", searchDto.getDescription()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }

    public void deleteContractorOrgByOid(ContractorOrg  contractorOrg ) {
        SelectWrapper wrapper = SelectWrapper.instance();
        if (contractorOrg  != null){
            wrapper.eq("oid", contractorOrg.getOid());
        }
        delete(wrapper);
    }


    public List<ContractorOrg> findContractorOrgList(OrgDto searchDto, Page page){
        List<Criterion> criterionList = Lists.newArrayList();
        return selectPage(criterionList,page);
    }




}
