package com.bcxin.risk.org;

import com.bcxin.risk.contractor.domain.Assessment;
import com.bcxin.risk.hibernateplus.condition.DeleteWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.org.domain.AssessmentDao;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author zhangjianhua
 * @date 2018/4/28
 */
@Repository("AssessmentDao")
public class AssessmentDaoImpl extends DaoImpl<Assessment> implements AssessmentDao {

    @Override
    public Assessment findAssessmentByOid(Long oid) {
        return selectById(oid);
    }

    @Override
    public List<Assessment> ListassessmentListOrg() {
        return selectList();
    }

    @Override
    public Assessment findAssessmentByUuid(String uuid) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("uuid", uuid);
        return selectOne(wrapper);
    }

    @Override
    public void flushAssessment() {
        DeleteWrapper wrapper = DeleteWrapper.instance();
        delete(wrapper);
    }
}
