package com.bcxin.risk.log;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.compose.dto.SearchDto;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.springframework.stereotype.Repository;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Repository
public class LogExceptionDaoImpl extends DaoImpl<LogException> implements LogExceptionDao{

    @Resource
    private BaseDao baseDao;

    @Override
    public List<LogException> logExceptionList(SearchDto searchDTO, DwzPage page) {
        List<Criterion> criterionList = Lists.newArrayList();
        List<Order> orderList = new ArrayList<Order>();
        orderList.add(Order.desc("createOn"));
        if ( page == null ) {
            return baseDao.findByCriterion(LogException.class, criterionList,orderList);
        }
        return baseDao.findByCriterionForPage(LogException.class, criterionList, page,orderList);
    }

}
