package com.bcxin.risk.activity;

import cn.hutool.core.date.DateUtil;
import com.bcxin.risk.activity.dto.data.ActivityDataDTO;
import com.bcxin.risk.activity.dto.search.ActivitySearchDTO;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.dto.search.ParamDTO;
import com.bcxin.risk.common.util.ConfigUtil;
import com.bcxin.risk.common.util.ObjectUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.hibernateplus.utils.CollectionUtils;
import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;


@Repository
public class ActivityDaoImpl extends DaoImpl<Activity> implements ActivityDao {

    @Override
    public List<Activity> activityList() {
        return selectList();
    }


    @Override
    public Activity findActivityByActivityNo(String activityNo) {
        return selectOne(SelectWrapper.instance().eq("activityNo", activityNo));
    }

    @Override
    public List<Activity> findActivityByActivityName(String activityName, String filterId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("name", activityName);
        if (StringUtil.isNotEmpty(filterId)) {
            wrapper.notIn("oid", filterId);
        }
        wrapper.notIn("activityStatus", Lists.newArrayList(DictConst.ACTIVITYSTATUS_DEL, DictConst.ACTIVITYSTATUS_YQX));
        return selectList(wrapper);
    }


    @Override
    public Activity findActivityByOid(Long oid) {
        return selectById(oid);
    }


    @Override
    public List<ActivityDataDTO> findActivityDtoList(ActivitySearchDTO searchDto,
                                                     Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();

        if (searchDto != null) {
            if (searchDto.getActivityStatus() != null) {
                wrapper.eq("activityStatus", searchDto.getActivityStatus());
            }
            if (searchDto.getSponsor() != null) {
                wrapper.like("sponsor", searchDto.getSponsor());
            }
            if (searchDto.getOrderNo() != null) {
                wrapper.eq("orderNo", searchDto.getOrderNo());
            }
            if (searchDto.getStarttime() != null) {
                wrapper.ge("createOn", DateUtil.parseDate(searchDto.getStarttime()));
            }
            if (searchDto.getEndtime() != null) {
                wrapper.le("endDate", DateUtil.parseDate(searchDto.getEndtime()));
            }
            if (searchDto.getUser() != null) {
                wrapper.eq("user", searchDto.getUser());
            }
            if (searchDto.getActivityType() != null) {
                wrapper.eq("activityType", searchDto.getActivityType());
            }
            if (StringUtil.isNotEmpty(searchDto.getName())) {
                wrapper.like("name", searchDto.getName());
            }

        }
        wrapper.orderBy("updateOn", false);
        wrapper.orderBy("oid", false);
        List<Map<String, Object>> list = Lists.newArrayList();
        if (page == null) {
            list = queryMaps("select * from risk_activity ", wrapper);
        } else {
            Page rpage = queryMapsPage("select * from risk_activity ", wrapper, page);
            list = rpage.getRecords();
        }

        List<ActivityDataDTO> dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map<String, Object> map = (Map<String, Object>) result;
            ActivityDataDTO dto = new ActivityDataDTO(map);
            dto.setPage(page);
            dtoList.add(dto);
        });

        return dtoList;
    }


    @Override
    public Map<String, String> countActivity(ActivitySearchDTO dto) {
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuilder sql = new StringBuilder(
                "select "
                        + " sum(case r.activityStatus when '" + DictConst.ACTIVITYSTATUS_HDJS + "' then 1 else 0 end) as complete,"
                        + " sum(case r.activityStatus when '" + DictConst.ACTIVITYSTATUS_HDJS + "' then 0 else 1 end) as uncomplete"
                        + " from risk_activity r" + " ");
        if (dto.getUser() == null) {
            return Maps.newHashMap();
        } else {
            wrapper.eq("user_id", dto.getUser().getOid());
        }
        Map<String, String> countMap = Maps.newHashMap();
        Map<String, Object> result = queryMap(sql.toString(), wrapper);
        countMap.put("complete", result.get("complete") == null ? "0"
                : result.get("complete").toString());
        countMap.put("uncomplete", result.get("uncomplete") == null ? "0"
                : result.get("uncomplete").toString());
        return countMap;
    }

    @Override
    public List<ActivityDataDTO> findActivityByApprovalStatus(ActivitySearchDTO activitySearchDTO, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select " +
                " DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS createOn," +
                " a.oid,DATE_FORMAT(a.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn," +
                " p.province AS province ," +
                " c.city AS city ," +
                " area.area AS area ," +
                " a.`name` AS name ," +
                " a.activitySource ," +
                " a.address AS address," +
                " a.sponsor AS sponsor ," +
                " a.zsponsor AS zsponsor ," +
                " a.approvalStatus AS approvalStatus ," +
                " a.primaryStatus ," +
                " a.activityStatus AS activityStatus ," +
                " a.oid AS activityId ," +
                " a.startDate AS startDate ," +
                " a.endDate AS endDate " +
                " from risk_activity a " +
                " inner join base_region p on p.oid = a.province_id " +
                " left join base_region c on c.oid = a.city_id " +
                " left join base_region area on area.oid = a.area_id" +
                " where 1=1 and a.activityStatus != " + DictConst.ACTIVITYSTATUS_DEL;

        if (StringUtil.isNotEmpty(activitySearchDTO.getProvince())) {
            sql += " and a.province_id = '" + activitySearchDTO.getProvince() + "' ";
        }
        if (StringUtil.isNotEmpty(activitySearchDTO.getCity())) {
            sql += " and a.city_id = '" + activitySearchDTO.getCity() + "' ";
        }
        if (StringUtil.isNotEmpty(activitySearchDTO.getArea())) {
            sql += " and a.area_id  = '" + activitySearchDTO.getArea() + "' ";
        }

        wrapper.orderBy("a.createOn", false);
        wrapper.orderBy("a.oid", false);
        List<ActivityDataDTO> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            ActivityDataDTO dto = new ActivityDataDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }


    @Override
    public List<ActivityDataDTO> activityDataDTOList(ParamDTO paramDTO, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT  a.oid ," +
                "a.name," +
                "a.activitySource," +
                "a.history," +
                "a.activityNo," +
                "DATE_FORMAT(a.activityDate,'%Y-%m-%d %H:%i:%s') AS activityDate," +
                "a.activityType, " +
                "a.activityStatus," +
                "a.primaryStatus," +
                "a.gov, " +
                "a.isBackUp, " +
                "a.postMaterial, " +
                "a.needReport, " +
                "IF((SELECT COUNT(1) " +
                "   FROM risk_activityMaterial " +
                "  WHERE activityMaterialType = '1'" +
                " AND activity_id = a.oid ) =0 ,'0','1') AS isExistsPgbg , " +
                "a.province_id as province, " +
                "a.city_id as city, " +
                "a.area_id as area, " +
                "a.startDate, " +
                "a.endDate, " +
                "a.address, " +
                "a.sponsor, " +
                "a.zsponsor, " +
                "u.companyPhone " +
                " FROM risk_activity a " +
                " INNER JOIN risk_se_user u on  u.oid = a.user_id " +
                " where 1=1 and a.activityStatus != '88' ";
        if (paramDTO.getUser() != null) {
            sql += " and u.oid = " + paramDTO.getUser().getOid() + " ";
        }
        if (StringUtil.isNotEmpty(paramDTO.getKeyname())) {
            sql += " and a.name like '%" + paramDTO.getKeyname() + "%'" + " ";
        }
        if (DictConst.Y.equalsIgnoreCase(paramDTO.getProcess())) {
            sql += " and a.activityStatus not in (" + DictConst.ACTIVITYSTATUS_HDJS + ")" + " ";
        }
        if (DictConst.N.equalsIgnoreCase(paramDTO.getProcess())) {
            sql += " and a.activityStatus = '" + DictConst.ACTIVITYSTATUS_HDJS + "' ";
        }
        if (StringUtil.isNotEmpty(paramDTO.getIsBackUp())) {
            sql += " and a.isBackUp = '" + paramDTO.getIsBackUp() + "' ";
        }
        if (StringUtil.isNotEmpty(paramDTO.getActivityType())) {
            sql += " and a.activityType = '" + paramDTO.getActivityType() + "' ";
        }
        if (StringUtil.isNotEmpty(paramDTO.getStartDate())) {
            sql += " and a.startDate >= '" + paramDTO.getStartDate() + "' ";
        }
        if (StringUtil.isNotEmpty(paramDTO.getEndDate())) {
            sql += " and a.startDate <= '" + paramDTO.getEndDate() + "' ";
        }
        if (StringUtil.isNotEmpty(paramDTO.getActivityStatus())) {
            /* 承办方 */
            if (paramDTO.getActivityStatus().startsWith("C")) {
                String activityStatus = CharMatcher.digit().retainFrom(paramDTO.getActivityStatus());
                /* 选择的是申请中 */
                if (activityStatus.equals(DictConst.N)) {
                    sql += " AND (a.activityStatus in ('10','15','20','25') ";
                    sql += " AND a.primaryStatus IN ('10','20','30','SL10','SL30') OR (ISNULL(a.primaryStatus) AND a.activityStatus ='10') ) ";
                } else if (activityStatus.equals(DictConst.Y)) {
                    sql += " and a.activityStatus = '" + DictConst.ACTIVITYSTATUS_HDJS + "' ";
                } else {
                    sql += " and a.activityStatus = '" + activityStatus + "' ";
                }
            }
            /* 政府单位 */
            else if (paramDTO.getActivityStatus().startsWith("G")) {
                String activityStatus = CharMatcher.digit().retainFrom(paramDTO.getActivityStatus());
                sql += " and a.activityStatus = '" + activityStatus + "' ";
            }
        }

        if (StringUtil.isNotEmpty(paramDTO.getActivitySource())) {
            sql += " and a.activitySource = '" + paramDTO.getActivitySource() + "' ";
        }

        if(StringUtil.isNotEmpty(paramDTO.getProvince())){
            sql += " and a.province_id = '" + paramDTO.getProvince() + "' ";
        }

        if(StringUtil.isNotEmpty(paramDTO.getCity())){
            sql += " and a.city_id = '" + paramDTO.getCity() + "' ";
        }

        if(StringUtil.isNotEmpty(paramDTO.getArea())){
            sql += " and a.area_id = '" + paramDTO.getArea() + "' ";
        }

        if(StringUtil.isNotEmpty(paramDTO.getProfile())){
            sql += " and a.province_id = '" + paramDTO.getProfile() + "' ";
        }

        wrapper.orderBy("a.createOn", false);
        List<ActivityDataDTO> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            ActivityDataDTO dto = new ActivityDataDTO(result);
            if(StringUtils.isNotBlank(paramDTO.getProfile())) {
                dto.setProvince(ConfigUtil.getRegion(dto.getProvince()));
            }
            dto.setCity(ConfigUtil.getRegion(dto.getCity()));
            dto.setArea(ConfigUtil.getRegion(dto.getArea()));
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }



    @Override
    public List<ActivityDataDTO> activityServiceOrgDataDTOList(ParamDTO paramDTO, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT  a.oid ," +
                "a.name," +
                "a.activitySource," +
                "a.history," +
                "a.activityNo," +
                "DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS createOn," +
                "a.activityType, " +
                "a.activityStatus," +
                "a.primaryStatus," +
                "a.gov, " +
                "a.isBackUp, " +
                "a.postMaterial, " +
                "a.needReport, " +
                "IF((SELECT COUNT(1) " +
                "   FROM risk_activityMaterial " +
                "  WHERE activityMaterialType = '1'" +
                " AND activity_id = a.oid ) =0 ,'0','1') AS isExistsPgbg , " +
                "a.province_id as province, " +
                "a.city_id as city, " +
                "a.area_id as area, " +
                "a.startDate, " +
                "a.endDate, " +
                "a.address, " +
                "a.sponsor, " +
                "a.zsponsor, " +
                "u.companyPhone, " +
                "ext.dataStatus, " +
                " ifnull(ext.securityCompanyName,'无') as securityCompanyName, " +
                " ifnull(ext.securityComId,'无') as securityComId " +
                " FROM risk_activity a " +
                " INNER JOIN risk_se_user u on  u.oid = a.user_id " +
                " left join (select * from risk_activity_ext group by activityId) ext on ext.activityId = a.oid "+
                " where 1=1 and a.activityStatus != '88' ";
        if (paramDTO.getUser() != null) {
            sql += " and u.oid = " + paramDTO.getUser().getOid() + " ";
        }
        if (StringUtil.isNotEmpty(paramDTO.getKeyname())) {
            sql += " and a.name like '%" + paramDTO.getKeyname() + "%'" + " ";
        }
        if (DictConst.Y.equalsIgnoreCase(paramDTO.getProcess())) {
            sql += " and a.activityStatus not in (" + DictConst.ACTIVITYSTATUS_HDJS + ")" + " ";
        }
        if (DictConst.N.equalsIgnoreCase(paramDTO.getProcess())) {
            sql += " and a.activityStatus = '" + DictConst.ACTIVITYSTATUS_HDJS + "' ";
        }
        if (StringUtil.isNotEmpty(paramDTO.getIsBackUp())) {
            sql += " and a.isBackUp = '" + paramDTO.getIsBackUp() + "' ";
        }
        if (StringUtil.isNotEmpty(paramDTO.getActivityType())) {
            sql += " and a.activityType = '" + paramDTO.getActivityType() + "' ";
        }
        if (StringUtil.isNotEmpty(paramDTO.getStartDate())) {
            sql += " and a.startDate >= '" + paramDTO.getStartDate() + "' ";
        }
        if (StringUtil.isNotEmpty(paramDTO.getEndDate())) {
            sql += " and a.startDate <= '" + paramDTO.getEndDate() + "' ";
        }
        if (StringUtil.isNotEmpty(paramDTO.getActivityStatus())) {
            /* 承办方 */
            if (paramDTO.getActivityStatus().startsWith("C")) {
                String activityStatus = CharMatcher.digit().retainFrom(paramDTO.getActivityStatus());
                /* 选择的是申请中 */
                if (activityStatus.equals(DictConst.N)) {
                    sql += " AND (a.activityStatus in ('10','15','20','25') ";
                    sql += " AND a.primaryStatus IN ('10','20','30','SL10','SL30') OR (ISNULL(a.primaryStatus) AND a.activityStatus ='10') ) ";
                } else if (activityStatus.equals(DictConst.Y)) {
                    sql += " and a.activityStatus = '" + DictConst.ACTIVITYSTATUS_HDJS + "' ";
                } else {
                    sql += " and a.activityStatus = '" + activityStatus + "' ";
                }
            }
            /* 政府单位 */
            else if (paramDTO.getActivityStatus().startsWith("G")) {
                String activityStatus = CharMatcher.digit().retainFrom(paramDTO.getActivityStatus());
                sql += " and a.activityStatus = '" + activityStatus + "' ";
            }
        }

        if (StringUtil.isNotEmpty(paramDTO.getActivitySource())) {
            sql += " and a.activitySource = '" + paramDTO.getActivitySource() + "' ";
        }

        if(StringUtil.isNotEmpty(paramDTO.getProvince())){
            sql += " and a.province_id = '" + paramDTO.getProvince() + "' ";
        }

        if(StringUtil.isNotEmpty(paramDTO.getCity())){
            sql += " and a.city_id = '" + paramDTO.getCity() + "' ";
        }

        if(StringUtil.isNotEmpty(paramDTO.getArea())){
            sql += " and a.area_id = '" + paramDTO.getArea() + "' ";
        }

        if(StringUtil.isNotEmpty(paramDTO.getProfile())){
            sql += " and a.province_id = '" + paramDTO.getProfile() + "' ";
        }

        wrapper.orderBy("a.createOn", false);
        List<ActivityDataDTO> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            ActivityDataDTO dto = new ActivityDataDTO(result);
            if(StringUtils.isNotBlank(paramDTO.getProfile())) dto.setProvince(ConfigUtil.getRegion(dto.getProvince()));
            dto.setCity(ConfigUtil.getRegion(dto.getCity()));
            dto.setArea(ConfigUtil.getRegion(dto.getArea()));
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Override
    public void cancelActivity(Long activityId) {
        String sql = "UPDATE risk_activity SET activityStatus = '" + DictConst.ACTIVITYSTATUS_YQX + "' WHERE  oid = " + activityId;
        executeSqlUpdate(sql);
    }

    @Override
    public List listActivity(DwzPage page, ActivitySearchDTO searchDTO) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT a.*,b.activityType,c.city from risk_activity a " +
                " INNER JOIN base_region c  ON a.city_id =c.oid ";
        if (StringUtil.isNotEmpty(searchDTO.getSponsor())) {
            sql = sql + " AND a.sponsor like '%" + searchDTO.getSponsor() + "%' ";
        }
        if (StringUtil.isNotEmpty(searchDTO.getActivityNo())) {
            sql = sql + " AND a.activityNo like '%" + searchDTO.getActivityNo() + "%' ";
        }
        if (StringUtil.isNotEmpty(searchDTO.getActivityStatus())) {
            sql = sql + " AND a.activityStatus =" + searchDTO.getActivityStatus();
        }

        if (StringUtil.isNotEmpty(searchDTO.getStartDate())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') >= '" + searchDTO.getStartDate() + "' ";
        }
        if (StringUtil.isNotEmpty(searchDTO.getEndDate())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') <= '" + searchDTO.getEndDate() + "' ";
        }
        if (page != null) {
            page.setTotalCount(querySqlCounts(sql, wrapper));
            sql = sql + " ORDER BY oid DESC limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return queryMaps(sql, wrapper);
    }

    @Override
    public List<Map<String, Object>> listMaterialPath(String oid, String activityMaterialType) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT `value` FROM risk_activitymaterial WHERE activityMaterialType  = " + activityMaterialType +
                " AND activity_id = " + oid;
        return queryMaps(sql, wrapper);
    }

    @Override
    public void updatePushSignForGoodBadComment(Long activityId) {
        String sql = "UPDATE risk_activity SET isPushBadGoodSystem = '" + DictConst.HEBEI_GOODBAD_PUSHED + "' WHERE  oid = " + activityId;
        executeSqlUpdate(sql);
    }

    @Override
    public List<Activity> findNotPushForGoodBadComment() {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("isPushBadGoodSystem", "0");
        wrapper.isNotNull("zwId");
        return selectList(wrapper);

    }

    @Override
    public boolean isExist(String zwId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("zwId", zwId);
        List list = selectList(wrapper);
        if (list.size() > 0) {
            return true;
        }
        return false;
    }

    @Override
    public String selectLastActivityProjId(String areaCode) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select zwId from risk_activity where createOn > CONCAT('" + DateUtil.today() + "',' 00:00:00') and area_id = " + areaCode + " order by zwId desc limit 1";
        List<Map<String, Object>> maps = queryMaps(sql, wrapper);
        if (CollectionUtils.isEmpty(maps)) {
            return "";
        }
        return ObjectUtil.safeTransfor(maps.get(0).get("zwId"));
    }

    @Override
    public Activity findActivityByZwId(String zwId) {
        return selectOne(SelectWrapper.instance().eq("zwId", zwId));

    }

}
