package com.bcxin.risk.common.dao;

import com.bcxin.risk.common.domain.Message;
import com.bcxin.risk.common.dto.data.MessageDataDto;
import com.bcxin.risk.common.dto.search.MessageSearchDto;
import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.user.domain.User;

import java.util.List;
import java.util.Map;

public interface MessageDao extends IDao<Message> {

    Message findMessageByOid(Long oid);

    List<Message> findMessageList(MessageSearchDto searchDto, Page page);

    List<MessageDataDto> findMessageByDto(MessageSearchDto searchDto, Page page);

    Map<String, String> countMessage(User user);

    void updateMessage(Message message);
}
