/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.base.dao;

import com.bcxin.risk.base.dao.util.SpringContextUtil;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;

public class QueryHelper {
    private static SessionFactory SESSION_FACTORY;

    public static SessionFactory getSessionFactory() {
        if (SESSION_FACTORY == null) {
            SESSION_FACTORY = (SessionFactory)SpringContextUtil.getBean("sessionFactory");
        }
        return SESSION_FACTORY;
    }

    public static List<? extends Object> findList(String hql) {
        try {
            return QueryHelper.findList(hql, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<? extends Object> findList(String hql, int start, int end) {
        try {
            Query query = QueryHelper.getSessionFactory().getCurrentSession().createQuery(hql);
            return query.setFirstResult(start).setMaxResults(end).list();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<? extends Object> findList(String hql, Map<String, Object> paramMap) {
        try {
            Query query = QueryHelper.getSessionFactory().getCurrentSession().createQuery(hql);
            if (paramMap != null && paramMap.size() != 0) {
                for (String key : paramMap.keySet()) {
                    Object param = paramMap.get(key);
                    query.setParameter(key, param);
                }
            }
            return query.list();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<? extends Object> findList(String hql, Map<String, Object> paramMap, Integer pageIndex, Integer pageSize) {
        try {
            Query query = QueryHelper.getSessionFactory().getCurrentSession().createQuery(hql);
            query.setFirstResult(pageIndex.intValue());
            query.setMaxResults(pageSize.intValue());
            if (paramMap != null && paramMap.size() != 0) {
                for (String key : paramMap.keySet()) {
                    Object param = paramMap.get(key);
                    query.setParameter(key, param);
                }
            }
            return query.list();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<? extends Object> findList1(String sql, Map<String, Object> paramMap, Integer pageIndex, Integer pageSize) {
        try {
            Query query = QueryHelper.getSessionFactory().getCurrentSession().createSQLQuery(sql).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            query.setFirstResult(pageIndex.intValue());
            query.setMaxResults(pageSize.intValue());
            if (paramMap != null && paramMap.size() != 0) {
                for (String key : paramMap.keySet()) {
                    Object param = paramMap.get(key);
                    query.setParameter(key, param);
                }
            }
            return query.list();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object uniqueResult(String hql, Map<String, Object> paramMap) {
        try {
            Query query = QueryHelper.getSessionFactory().getCurrentSession().createQuery(hql);
            if (paramMap != null && paramMap.size() != 0) {
                for (String key : paramMap.keySet()) {
                    Object param = paramMap.get(key);
                    query.setParameter(key, param);
                }
            }
            return ((Number)query.iterate().next()).intValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Object> findBySql(String sql, Map<String, Object> paramMap) {
        Query query = QueryHelper.getSessionFactory().getCurrentSession().createSQLQuery(sql).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        if (paramMap != null && paramMap.size() != 0) {
            for (String key : paramMap.keySet()) {
                Object param = paramMap.get(key);
                query.setParameter(key, param);
            }
        }
        return query.list();
    }

    public static List<Object> findBySql(String sql, Map<String, Object> paramMap, int numberOfPage, int pageNum) {
        Query query = QueryHelper.getSessionFactory().getCurrentSession().createSQLQuery(sql).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        if (paramMap != null && paramMap.size() != 0) {
            for (String key : paramMap.keySet()) {
                Object param = paramMap.get(key);
                query.setParameter(key, param);
            }
        }
        query.setFirstResult((pageNum - 1) * numberOfPage);
        query.setMaxResults(numberOfPage);
        return query.list();
    }

    public static List<Object> findBySql(String sql, int start, int limit) {
        Query query = QueryHelper.getSessionFactory().getCurrentSession().createSQLQuery(sql).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        query.setFirstResult(start);
        query.setMaxResults(limit);
        return query.list();
    }

    public static Map<String, Object> findBySql(String sql, String countSql, int start, int limit) {
        Query query = QueryHelper.getSessionFactory().getCurrentSession().createSQLQuery(sql).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        query.setFirstResult(start);
        query.setMaxResults(limit);
        Query countQuery = QueryHelper.getSessionFactory().getCurrentSession().createSQLQuery(countSql).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        Object totalProperty = countQuery.uniqueResult();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("totalProperty", Long.valueOf(((Map)totalProperty).get("totalProperty").toString()));
        map.put("root", query.list());
        return map;
    }

    public static List<? extends Object> findSingle(String hql) {
        try {
            Query query = QueryHelper.getSessionFactory().getCurrentSession().createQuery(hql);
            query.setMaxResults(1);
            return query.list();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object executeSql(String sql, Map<String, Object> paramMap) {
        try {
            NativeQuery query = QueryHelper.getSessionFactory().getCurrentSession().createSQLQuery(sql);
            if (paramMap != null && paramMap.size() != 0) {
                for (String key : paramMap.keySet()) {
                    Object param = paramMap.get(key);
                    query.setParameter(key, param);
                }
            }
            Integer rs = query.executeUpdate();
            return rs;
        }
        catch (Exception e) {
            e.printStackTrace();
            return paramMap;
        }
    }

    public static void executeHql(String hql) {
        try {
            QueryHelper.getSessionFactory().getCurrentSession().createQuery(hql).executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void executeHql(String hql, Map<String, Object> paramMap) {
        try {
            Query query = QueryHelper.getSessionFactory().getCurrentSession().createQuery(hql);
            if (!CollectionUtil.isEmpty(paramMap)) {
                for (String key : paramMap.keySet()) {
                    Object param = paramMap.get(key);
                    query.setParameter(key, param);
                }
            }
            query.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

