<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<%
    String path = request.getContextPath();
    String basePath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/";
%>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <base href="@@baseUrl">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="renderer" content="webkit">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <title>收入明细</title>
    <link rel="stylesheet" href="/static/weixin/css/public.css">
    <link rel="stylesheet" href="/static/weixin/css/basic.css">
    <link rel="stylesheet" href="/static/weixin/css/wechat_add_new.css">
    <link rel="stylesheet" href="/static/weixin/css/new_basic.css">
    <link rel="stylesheet" href="/static/weixin/css/management_system.css?v=1.0.6">
    <script type="text/javascript" src="/static/weixin/js/flexible.js"></script>
    <style>
        #ert{
            display: none;
            text-align: center;
            font-size: 16px;
            padding: 10px;
            color: #7e95c4;
        }
        [data-dpr="2"] #scroller p#ert{
            font-size: 32px;
        }
        [data-dpr="3"] #scroller p#ert{
            font-size: 48px;
        }
    </style>

    <script type="text/javascript" >
        var weixin_login_distribution_level = "${p.weixin_login_distribution_level}";
        var weixin_login_company_type = "${p.weixin_login_company_type}";
    </script>
</head>
<body id="contain">
<div class="contain">
    <div class="bai-head">
        <span>收入明细</span>
        <a href="/weixin/billNewPage/index" class="left">
            <img src="/static/weixin/images/head-left.png"/>
        </a>
        <a href="javascript:void(0);" id="condition" class="right">筛选</a>
    </div>
    <div id="wrapper">
        <div class="sdf" id="scroller">

            <!--新的替换start-->
            <div class="management-system">
                <div class="system-money">
                    <div class="money-content-a1">
                        <div class="a1-left">
                            <h3>当前总收入：<br/><span id="currAmountTotal">￥0.00</span></h3>
                            <p>共<span id="totalCount">0</span>单</p>
                        </div>
                        <div class="a1-right">
                            <c:if test="${p.weixin_login_company_type!=4}">
                            <div class="right-cont">
                                <p>下级收入</p>
                                <span id="lowerAmountTotal">￥0.00</span>
                            </div>
                            </c:if>

                            <c:if test="${p.weixin_login_distribution_level eq '1' || p.weixin_login_company_type eq '4'}">
                            <div class="right-cont">
                                <p>已结算</p>
                                <span id="settleAmount">￥0.00</span>
                            </div>
                            </c:if>
                            <c:if test="${p.weixin_login_company_type!=4}">
                            <div class="right-cont">
                                <p>净收入</p>
                                <span id="currAmount">￥0.00</span>
                            </div>
                            </c:if>

                            <c:if test="${p.weixin_login_distribution_level eq '1' || p.weixin_login_company_type eq '4'}">
                            <div class="right-cont">
                                <p>未结算</p>
                                <span id="noSettleAmount">￥0.00</span>
                            </div>
                            </c:if>
                        </div>
                    </div>
                </div>
                <div class="system-footer">
                    <span>最近账单</span>
                    <a href="javaScript:void(0);" class="exportExcel" onclick="exportExcel()">导出Excel文件</a>
                </div>
            </div>
            <!--新的替换end-->

            <ul class="home-bill" id="thelist">
                <%--<li>--%>
                    <%--<div class="bill-head">--%>
                        <%--<span>订单号：<em>98000000000000000</em></span>--%>
                        <%--<a href="javascript:;">查看详情 ></a>--%>
                    <%--</div>--%>
                    <%--<div class="bill-text">--%>
                        <%--<p class="an">--%>
                            <%--<span>--%>
                                <%--安保无忧全年意外险计划四安保无忧全年意外险计划四安保无忧全年意外险计划四--%>
                            <%--</span>--%>
                        <%--</p>--%>
                        <%--<p class="jie">--%>
                            <%--<span>已结算</span>--%>
                            <%--<i>来源: <em>本级名称</em></i>--%>
                        <%--</p>--%>
                        <%--<p class="bill-time">--%>
                            <%--支付时间：2018-04-28 16:16:16--%>
                        <%--</p>--%>
                    <%--</div>--%>
                    <%--<div class="bill-footer">--%>
                        <%--<div class="footer-cont">--%>
                            <%--<p>订单金额：<span>￥5000.00</span></p>--%>
                            <%--<p>下级收入：<span>￥500.00</span></p>--%>
                        <%--</div>--%>
                        <%--<div class="footer-cont">--%>
                            <%--<p>订单收入：<span>￥5000.00</span></p>--%>
                            <%--<p>净收入：<span>￥500.00</span></p>--%>
                        <%--</div>--%>
                    <%--</div>--%>
                <%--</li>--%>
            </ul>
            <div id="pullUp">
                <span class="pullUpLabel">上拉加载更多...</span>
            </div>
            <p id="ert"></p>
        </div>
    </div>
</div>
<script src="/static/weixin/js/jquery-1.8.3.min.js"></script>
<%--<script src="/static/weixin/js/mobiscroll/mobiscroll_002.js" type="text/javascript"></script>--%>
<%--<script src="/static/weixin/js/mobiscroll/mobiscroll_004.js" type="text/javascript"></script>--%>
<%--<script src="/static/weixin/js/mobiscroll/mobiscroll.js" type="text/javascript"></script>--%>
<%--<script src="/static/weixin/js/mobiscroll/mobiscroll_003.js" type="text/javascript"></script>--%>
<%--<script src="/static/weixin/js/mobiscroll/mobiscroll_005.js" type="text/javascript"></script>--%>

<script src="/static/weixin/common/layer_mobile/layer.js"></script>
<link rel="stylesheet" href="/static/weixin/common/layer_mobile/need/right.css">
<script src="/static/weixin/common/jquery.formHelper.js"></script>
<script type="text/javascript" src="/static/weixin/js/iscroll.js"></script>
<%--<script type="text/javascript" src="/static/weixin/js/revenue_scroll_content.js"></script>--%>
<script type="text/javascript" src="/static/weixin/js/g.js?v=1.0.6"></script>
<script type="text/javascript" src="/static/weixin/js/base64.js"></script>
<script src="/static/weixin/common/clipboard.min.js"></script>

<script type="text/javascript">
    var myScroll, pullUpEl, pullUpOffset;
    var p = { limit: 5, offset: 0 };
    //初始化绑定iScroll控件
    document.addEventListener('touchmove', function (e) { e.preventDefault(); }, false);
    document.addEventListener('DOMContentLoaded', loaded, false);

    $(function(){
        bindData();
        //绑定筛选事件
        $("#condition").click(function(){
            window.location.href="/weixin/billNewPage/billCondition?product_type=${p.product_type}"
        });
        getData();
    });

    /**
     * 绑定数据
     */
    function bindData(){
        var currAmountTotal=number_format('${billOrderTotal.currAmountTotal}',2,'.',',');
        $("#currAmountTotal").html('￥'+currAmountTotal);

        var totalCount='${billOrderTotal.totalCount}';
        $("#totalCount").html(totalCount);

        var lowerAmountTotal=number_format('${billOrderTotal.lowerAmountTotal}',2,'.',',');
        $("#lowerAmountTotal").html('￥'+lowerAmountTotal);

        var settleAmount=number_format('${billOrderTotal.settleAmount}',2,'.',',');
        $("#settleAmount").html('￥'+settleAmount);

        var currAmount=number_format('${billOrderTotal.currAmount}',2,'.',',');
        $("#currAmount").html('￥'+currAmount);

        var noSettleAmount=number_format('${billOrderTotal.noSettleAmount}',2,'.',',');
        $("#noSettleAmount").html('￥'+noSettleAmount);
    }

    //清空查询条件缓存
    function clearConditionCache(){
        sessionStorage.removeItem("sel_orderNo");
        sessionStorage.removeItem("sel_region");
        sessionStorage.removeItem("sel_startTime");
        sessionStorage.removeItem("sel_endTime");
        sessionStorage.removeItem("sel_project");
        sessionStorage.removeItem("sel_company");
    }

    /**
     * 重新加载统计数据
     */
    function reloadAmountTotal(){
        g_ajax("/weixin/billNew/getBillOrderTotal",p,function(billOrderTotal){
            var currAmountTotal=number_format(billOrderTotal.currAmountTotal,2,'.',',');
            $("#currAmountTotal").html('￥'+currAmountTotal);

            var totalCount=billOrderTotal.totalCount;
            $("#totalCount").html(totalCount);

            var lowerAmountTotal=number_format(billOrderTotal.lowerAmountTotal,2,'.',',');
            $("#lowerAmountTotal").html('￥'+lowerAmountTotal);

            var settleAmount=number_format(billOrderTotal.settleAmount,2,'.',',');
            $("#settleAmount").html('￥'+settleAmount);

            var currAmount=number_format(billOrderTotal.currAmount,2,'.',',');
            $("#currAmount").html('￥'+currAmount);

            var noSettleAmount=number_format(billOrderTotal.noSettleAmount,2,'.',',');
            $("#noSettleAmount").html('￥'+noSettleAmount);
        },true);
    }

    /**
     * 获取数据
     */
    function getData(){
        getSearchParam();
        reloadAmountTotal();

        layer.open({type:2});
        g_ajax("/weixin/billNew/getBillOrderList",p ,function(json){
            var el, li;
            var rows = json.rows;
            el = document.getElementById('thelist');
            if(rows.length==0) { //长度为空，或者小于limit条数，说明是已经到最后了
                layer.closeAll();
                $("#pullUp").hide();
                $("#ert").text('数据已经加载完了！').show();
                return;
            }else{
                p.offset += p.limit;
            }
            for(var i in rows){
                var monthStatus = rows[i].monthStatus=="0"?"未结算":"已结算";
                // if(weixin_login_distribution_level=="2" || weixin_login_distribution_level=="3" ){
                //     monthStatus = "";
                // }
                var sourceCompanyName="";
                if(rows[i].sourceCompanyName!=null){
                    sourceCompanyName=formatterStr(rows[i].sourceCompanyName);
                }
                li = document.createElement('li');
                var html =
                    '<div class="bill-head"><span>单号：'+ rows[i].orderNo + '</span><a href="/weixin/billNewPage/detail/'+rows[i].orderId+'">点击查看详情 &gt;</a></div>'
                    + '<div class="bill-text"><p class="an"><span>'+rows[i].projectName+'</span></p>';

                //只有1级或者资源方才有结算状态
                if(weixin_login_distribution_level=='1' || weixin_login_company_type =='4'){
                    html+= '<p class="jie"><span>'+monthStatus+'</span>';
                }else{
                    html+= '<p class="jie">';
                }
                //保险产品
                if(rows[i].productType=='6' && weixin_login_company_type =='2'){
                    html+='<i>来源: <em>'+sourceCompanyName+'</em></i>';
                }

                html+='</p>'
                    + '<p class="bill-time">支付时间：'+ formatterStr( rows[i].payDate )+'</p>'
                    + '</div>'
                    + '<div class="bill-footer">'
                    + '<div class="footer-cont">'
                    + '<p>订单金额：<span>￥'+ number_format(rows[i].orderAmount,2,'.',',') +'</span></p>';
                if(weixin_login_company_type!='4'){
                    html+= '<p>下级收入：<span>￥'+ number_format(rows[i].lowerOrderAmount,2,'.',',') +'</span></p>';
                }

                html+= '</div>'
                    + '<div class="footer-cont">'
                    + '<p>订单收入：<span>￥'+ number_format(rows[i].currOrderAmount,2,'.',',') +'</span></p>';

                if(weixin_login_company_type!='4') {
                    html+='<p>净收入：<span>￥' + number_format(rows[i].currAmount, 2, '.', ',') + '</span></p>';
                }
                html+='</div>'
                    + '</div>';

                li.innerHTML=html;
                el.appendChild(li, el.childNodes[0]);
            }
            layer.closeAll();
        },false);
    }

    /**
     * 获取查询参数
     */
    function getSearchParam(){
        //增加6个条件
        //销售区域
        if(sessionStorage.getItem("sel_region")!=null){
            var selRegion = JSON.parse(sessionStorage.getItem("sel_region")); //选择地区
            p.area = selRegion.region_id;
        }else{
            delete p.area;
        }

        //支付开始时间
        if(sessionStorage.getItem("sel_startTime")!=null) {
            var startTime = JSON.parse(sessionStorage.getItem("sel_startTime")); //开始时间
            p.startDate = startTime;
        }else{
            delete p.startDate;
        }

        //支付结束时间
        if(sessionStorage.getItem("sel_endTime")!=null) {
            var endTime = JSON.parse(sessionStorage.getItem("sel_endTime")); //结束时间
            p.endDate = endTime;
        }else{
            delete p.endDate;
        }

        //项目名称
        if(sessionStorage.getItem("sel_project")!=null) {
            var selProject = JSON.parse(sessionStorage.getItem("sel_project")); //选择地区
            p.projectName = selProject;
        }else{
            delete p.projectName;
        }

        //来源分销商
        if(sessionStorage.getItem("sel_company")!=null) {
            var sel_company = JSON.parse(sessionStorage.getItem("sel_company")); //选择地区
            p.companyId = sel_company.company_id;
        }else{
            delete p.companyId;
        }

        //产品类型
        if(sessionStorage.getItem("sel_product_type")!=null) {
            var sel_product_type = JSON.parse(sessionStorage.getItem("sel_product_type"));
            p.product_type = sel_product_type;
        }else{
            delete p.product_type;
        }

        //订单号
        if(sessionStorage.getItem("sel_orderNo")!=null) {
            var sel_order_no = JSON.parse(sessionStorage.getItem("sel_orderNo"));
            p.orderNo = sel_order_no;
        }else{
            delete p.orderNo;
        }
    }

    /***
     * 获取导出excelName
     */
    function getExcelName() {
        var regionName="";
        var startDate="";
        var endDate="";
        var projectName="";
        var sourceName="";
        var companyName="${p.weixin_login_company_name}";
        var fileName=companyName;
        if(sessionStorage.getItem("sel_region")!=null){
            var selRegion = JSON.parse(sessionStorage.getItem("sel_region")); //选择地区
            regionName=selRegion.region_name;
        }
        //支付开始时间
        if(sessionStorage.getItem("sel_startTime")!=null) {
            startDate = JSON.parse(sessionStorage.getItem("sel_startTime")); //开始时间
        }
        //支付结束时间
        if(sessionStorage.getItem("sel_endTime")!=null) {
            endDate = JSON.parse(sessionStorage.getItem("sel_endTime")); //结束时间
        }
        //项目名称
        if(sessionStorage.getItem("sel_project")!=null) {
            projectName = JSON.parse(sessionStorage.getItem("sel_project")); //选择地区
        }
        //来源分销商
        if(sessionStorage.getItem("sel_company")!=null) {
            var sel_company = JSON.parse(sessionStorage.getItem("sel_company")); //选择地区
            sourceName = sel_company.company_name;
        }

        //下级
        if(sourceName!='' && companyName!=sourceName){
            fileName+="_"+sourceName;
        }
        //区域
        if(regionName!=""){
            fileName+="_"+regionName;
        }
        if(startDate!='' && endDate!=''){
            fileName+="_"+startDate+"~"+endDate;
        }
        if(projectName!=''){
            fileName+="_"+projectName;
        }
        fileName+=".xls";
        return fileName;

    }

    function pullUpAction () {
        getData();
        myScroll.refresh();		// 数据加载完成后，调用界面更新方法 Remember to refresh when contents are loaded (ie: on ajax completion)
    }

    /**
     * 初始化iScroll控件
     */
    function loaded() {
        pullUpEl = document.getElementById('pullUp');
        pullUpOffset = pullUpEl.offsetHeight;

        myScroll = new iScroll('wrapper', {
            scrollbarClass: 'myScrollbar', /* 重要样式 */
            scrollbars: true,
            mouseWheel: true,//允许滑轮滚动
            useTransition: false, /* 此属性不知用意，本人从true改为false 动画 */
            onRefresh: function () {
                if (pullUpEl.className.match('loading')) {
                    pullUpEl.className = '';
                    pullUpEl.querySelector('.pullUpLabel').innerHTML = '上拉加载更多...';
                }
            },
            onScrollMove: function () {
                if (this.y < (this.maxScrollY - 55) && !pullUpEl.className.match('flip')) {
                    pullUpEl.className = 'flip';
                    pullUpEl.querySelector('.pullUpLabel').innerHTML = '松手开始更新...';
                    this.maxScrollY = this.maxScrollY;
                } else if (this.y > (this.maxScrollY + 55) && pullUpEl.className.match('flip')) {
                    pullUpEl.className = '';
                    pullUpEl.querySelector('.pullUpLabel').innerHTML = '上拉加载更多...';
                    this.maxScrollY = pullUpOffset;
                }
            },
            onScrollEnd: function () {
                if (pullUpEl.className.match('flip')) {
                    pullUpEl.className = 'loading';
                    pullUpEl.querySelector('.pullUpLabel').innerHTML = '正在加载...';
                    pullUpAction();	// Execute custom function (ajax call?)
                }
            }
        });

        setTimeout(function () { document.getElementById('wrapper').style.left = '0'; }, 800);
    }

    /***
     * 导出excel
     */
    function exportExcel() {
        var basePath='<%=basePath%>';
        var fileName=getExcelName();
        fileName="收入明细表_"+fileName;
        var params=p;
        params.excelName=fileName;
        params.sheetName="日结订单";
        params.weixin_login_terminal_type='${p.weixin_login_terminal_type}';
        params.weixin_login_company_name='${p.weixin_login_company_name}';
        params.weixin_login_company_id='${p.weixin_login_company_id}';
        params.weixin_login_user_id='${p.weixin_login_user_id}'+'';
        params.weixin_login_distribution_level='${p.weixin_login_distribution_level}';
        params.weixin_login_company_type='${p.weixin_login_company_type}';
        var url = "/weixin/billNew/exportOrderExcel";
        var json=JSON.stringify(params);
        var b = new Base64();
        var str = b.encode(encodeURIComponent(json));
        var reqUrl=url+"?params="+encodeURIComponent(str);

        if(is_weixin()){
            //微信浏览器
            var clipboard = new Clipboard('.exportExcel', {
                text: function (value) {
                    return basePath+reqUrl;
                }
            });

            clipboard.on('success', function(e) {
                layer.open({content:"Excel导出链接已经拷贝，请在浏览器中打开",btn: '我知道了'});
            });
        }else{
            window.open(reqUrl,"_blank")
        }

        // var form = $("<form></form>").attr("action", url).attr("method", "post");
        // form.append($("<input></input>").attr("type", "hidden").attr("name", "params").attr("value", json));
        // form.appendTo('body').submit().remove();
    }

    function formatterStr(val) {
        if(val!=undefined && val!=null){
            return val;
        }
        return "--";
    }

</script>
</body>
</html>