/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.cron.pattern.parser;

import com.xiaoleilu.hutool.cron.CronException;
import com.xiaoleilu.hutool.cron.pattern.parser.ValueParser;

public class SimpleValueParser
implements ValueParser {
    protected int min;
    protected int max;

    public SimpleValueParser(int min, int max) {
        if (min > max) {
            this.min = max;
            this.max = min;
        } else {
            this.min = min;
            this.max = max;
        }
    }

    @Override
    public int parse(String value) throws CronException {
        int i;
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new CronException(e, "Invalid integer value: [{}]", value);
        }
        if (i < this.min || i > this.max) {
            throw new CronException("Value [{}] out of range: [{} , {}]", i, this.min, this.max);
        }
        return i;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }
}

