package com.bcxin.tenant.domain.v5.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;
import com.bcxin.Infrastructures.enums.ApprovedStatus;
import lombok.Getter;

@Getter
public class ApprovedDomainCommand extends CommandAbstract {
    private final String id;
    private final LocationValueType placeOfRegister;
    private final LocationValueType placeOfBusiness;
    private final ApprovedStatus status;
    private final String institutionalCode;
    private final String superviseRegionCode;

    public ApprovedDomainCommand(String id,
                                 LocationValueType placeOfRegister,
                                 LocationValueType placeOfBusiness,
                                 ApprovedStatus status, String institutionalCode,String superviseRegionCode) {
        this.id = id;
        this.placeOfRegister = placeOfRegister;
        this.placeOfBusiness = placeOfBusiness;
        this.status = status;
        this.institutionalCode = institutionalCode;
        this.superviseRegionCode = superviseRegionCode;
    }

    /**
     * 注册地的省份+城市
     * 结合结构类型; 用于获取应用包
     *
     * @return
     */
    public String getRegisterCity() {
        if (placeOfRegister==null || placeOfRegister.getCity() == null) {
            return null;
        }

        return placeOfRegister.getCity().getName();
    }

    public String getRegisterProvince() {
        if (placeOfRegister == null || placeOfRegister.getProvince()==null) {
            return null;
        }

        return placeOfRegister.getProvince().getName();
    }

    public static ApprovedDomainCommand create(String id,
                                               LocationValueType placeOfRegister,
                                               LocationValueType placeOfBusiness,
                                               ApprovedStatus status, String institutionalCode,String superviseRegionCode) {
        return new ApprovedDomainCommand(id, placeOfRegister, placeOfBusiness, status, institutionalCode,superviseRegionCode);
    }

}
