package com.bcxin.tenant.domain.v5.dispatches;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.Collection;
import java.util.Map;

@Data
@ConfigurationProperties("patch.dispatch")
public class DispatchProperties {
    private String api;
    private Map<String, Collection<Certificate>> certificates;

    @Data
    public static class Certificate {
        private String method;
        private String clientId;
        private String secret;
        private String routeKey;
    }
}

