package com.bcxin.tenant.domain.v5.business.dtos;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.AccessLevel;
import lombok.*;
import javax.persistence.*;


@Table(name = "tlk_app_package")
@Entity
@Setter(AccessLevel.PROTECTED)
@Getter
public class AppPackageReadonlyDto extends EntityAbstract implements IAggregate {
    @Id
    private String id;
    //@Column(name = "ITEM_OWN_APPS")
    @Transient
    private String ownApps;
    @Column(name = "ITEM_REGISTERADDRESS")
    private String registerAddress;
    @Column(name = "ITEM_REGISTERADDRESSID")
    private String registerAddressId;

    @Column(name = "ITEM_BAOFFICETYPE")
    private String officeType;

    protected AppPackageReadonlyDto(){}

    protected AppPackageReadonlyDto(String id, String ownApps,String registerAddress,String registerAddressId, String officeType) {
        this.setId(id);
        this.setOwnApps(ownApps);
        this.setOfficeType(officeType);
        this.setRegisterAddress(registerAddress);
        this.setRegisterAddressId(registerAddressId);
    }

    public static  AppPackageReadonlyDto create(String id, String ownApps,String registerAddress,String registerAddressId, String officeType) {
        return new AppPackageReadonlyDto(id, ownApps, registerAddress, registerAddressId, officeType);
    }
}
