/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.components;

import com.bcxin.Infrastructures.exceptions.ConflictTenantException;
import com.bcxin.Infrastructures.exceptions.RetryableTenantException;
import org.springframework.stereotype.Component;

public interface RetryProvider {
    public void execute(Runnable var1, int var2);

    @Component
    public static class RetryProviderImpl
    implements RetryProvider {
        @Override
        public void execute(Runnable runnable, int times) {
            int retryTime = 0;
            while (true) {
                try {
                    runnable.run();
                    return;
                }
                catch (Exception ex) {
                    if (ex instanceof ConflictTenantException) {
                        throw ex;
                    }
                    ++retryTime;
                    if (ex instanceof RetryableTenantException || ex.getMessage().contains("No provider available")) {
                        if (retryTime > times) {
                            throw ex;
                        }
                    } else {
                        throw ex;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

