/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.utils;

import com.bcxin.tenant.open.domains.dtos.RoomCommunicatedGroupDTO;
import com.bcxin.tenant.open.domains.entities.ConfigOfBillEntity;
import com.bcxin.tenant.open.domains.entities.DeviceCommunicatedLogDetailEntity;
import com.bcxin.tenant.open.infrastructures.components.IdWorker;
import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

public class DeviceCommunicatedLogDetailUtils {
    public static Collection<DeviceCommunicatedLogDetailEntity> build(ConfigOfBillEntity config, IdWorker idWorker, Collection<RoomCommunicatedGroupDTO> communicatedGroups) {
        ArrayList<DeviceCommunicatedLogDetailEntity> deviceCommunicatedLogDetails = new ArrayList<DeviceCommunicatedLogDetailEntity>();
        for (RoomCommunicatedGroupDTO group : communicatedGroups) {
            Collection joinRoomUsers = group.getJoinRoomUsers().stream().filter(ix -> !ix.isCaller()).collect(Collectors.toList());
            if (group.getAudioVideoLogs() == null) continue;
            CommunicatedType communicatedType = group.getCommunicatedType();
            for (RoomCommunicatedGroupDTO.AudioVideoLogDto audioVideoLog : group.getAudioVideoLogs()) {
                for (RoomCommunicatedGroupDTO.JoinRoomUserDto roomUser : joinRoomUsers) {
                    DeviceCommunicatedLogDetailEntity logDetailEntity = null;
                    if (audioVideoLog.HasJoin(roomUser)) {
                        String logDetailDomainId = roomUser.getDomainId();
                        String logDetailDomainName = roomUser.getCompanyName();
                        logDetailEntity = DeviceCommunicatedLogDetailEntity.create(config, group.getDeskType(), idWorker.getNextId(), String.valueOf(roomUser.getInvitedUserRecordId()), group.getRoomId(), audioVideoLog.getCommunicatedType(), group.getCallerEmployeeId(), group.getCallerEmployeeName(), group.getCallerDeviceNo(), group.getCallerCompanyName(), roomUser.getEmployeeId(), roomUser.getEmployeeName(), roomUser.getDeviceNo(), logDetailDomainName, group.getCallerCompanyId(), logDetailDomainId, audioVideoLog.getActuallyBeginJoinTime(roomUser), audioVideoLog.getActuallyEndJoinTime(roomUser), group.getReferenceType(), group.getReferenceNumber(), group.isCallerPayTheBill(), group.getCallerOrgInstitutional(), roomUser.getProjectId(), roomUser.getProjectName());
                    }
                    if (logDetailEntity == null) continue;
                    if (roomUser.isSuperviseRole()) {
                        logDetailEntity.cleanPoints();
                    }
                    deviceCommunicatedLogDetails.add(logDetailEntity);
                }
            }
            DeviceCommunicatedLogDetailEntity firstCommunicatedLogDetail = deviceCommunicatedLogDetails.stream().findFirst().orElse(null);
            for (RoomCommunicatedGroupDTO.NoAnswerRoomUserRecordDto answerRoomUserRecord : group.getNoAnswerRoomUsers()) {
                DeviceCommunicatedLogDetailEntity newCommunicatedLogDetail = null;
                String logDetailDomainId = answerRoomUserRecord.getDomainId();
                String logDetailDomainName = answerRoomUserRecord.getCompanyName();
                newCommunicatedLogDetail = firstCommunicatedLogDetail != null ? firstCommunicatedLogDetail.copy(config, answerRoomUserRecord.getReferenceNumber(), String.valueOf(answerRoomUserRecord.getId()), answerRoomUserRecord.getEmployeeId(), answerRoomUserRecord.getEmployeeName(), answerRoomUserRecord.getDeviceNo(), logDetailDomainName, logDetailDomainId, answerRoomUserRecord.getCreatedTime(), null) : DeviceCommunicatedLogDetailEntity.create(config, group.getDeskType(), idWorker.getNextId(), String.valueOf(answerRoomUserRecord.getId()), group.getRoomId(), communicatedType, group.getCallerEmployeeId(), group.getCallerEmployeeName(), group.getCallerDeviceNo(), group.getCallerCompanyName(), answerRoomUserRecord.getEmployeeId(), answerRoomUserRecord.getEmployeeName(), answerRoomUserRecord.getDeviceNo(), logDetailDomainName, group.getCallerCompanyId(), logDetailDomainId, answerRoomUserRecord.getCreatedTime(), null, group.getReferenceType(), group.getReferenceNumber(), group.isCallerPayTheBill(), group.getCallerOrgInstitutional(), answerRoomUserRecord.getProjectId(), answerRoomUserRecord.getProjectName());
                if (newCommunicatedLogDetail == null) continue;
                deviceCommunicatedLogDetails.add(newCommunicatedLogDetail);
            }
        }
        return deviceCommunicatedLogDetails;
    }
}

