/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.infrastructures.enums;

import com.bcxin.tenant.open.infrastructures.utils.BusinessUtil;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RoleType {
    Urban{

        @Override
        public String getTypeName() {
            return "\u5e02\u5c40";
        }
    }
    ,
    SubUrb{

        @Override
        public String getTypeName() {
            return "\u5206\u5c40";
        }
    }
    ,
    PoliceStation{

        @Override
        public String getTypeName() {
            return "\u6d3e\u51fa\u6240";
        }
    }
    ,
    PopulationUrban{

        @Override
        public String getTypeName() {
            return "\u4eba\u53e3\u5e02\u5c40";
        }
    }
    ,
    PopulationSubUrb{

        @Override
        public String getTypeName() {
            return "\u4eba\u53e3\u5206\u5c40";
        }
    }
    ,
    PopulationPoliceStation{

        @Override
        public String getTypeName() {
            return "\u4eba\u53e3\u6d3e\u51fa\u6240";
        }
    }
    ,
    Company{

        @Override
        public String getTypeName() {
            return "\u4f01\u4e1a";
        }
    }
    ,
    Proprietor{

        @Override
        public String getTypeName() {
            return "\u5185\u4fdd\u5355\u4f4d";
        }
    };


    public abstract String getTypeName();

    public static RoleType create(String institutional, String orgName) {
        if (BusinessUtil.isSupervise(institutional)) {
            if (institutional.endsWith("07") || institutional.endsWith("08")) {
                if (BusinessUtil.isPopulationSupervise(institutional)) {
                    return PopulationUrban;
                }
                return Urban;
            }
            if (institutional.endsWith("09")) {
                if (BusinessUtil.isPopulationSupervise(institutional)) {
                    return PopulationSubUrb;
                }
                return SubUrb;
            }
            if (institutional.endsWith("10")) {
                if (BusinessUtil.isPopulationSupervise(institutional)) {
                    return PopulationPoliceStation;
                }
                return PoliceStation;
            }
            if (StringUtil.isEmpty(orgName)) {
                return PoliceStation;
            }
            if (orgName.contains("\u6d3e\u51fa\u6240")) {
                return PoliceStation;
            }
            if ((orgName.contains("\u4eba\u53e3") || BusinessUtil.isPopulationSupervise(institutional)) && orgName.contains("\u5206\u5c40")) {
                return PopulationSubUrb;
            }
            if ((orgName.contains("\u4eba\u53e3") || BusinessUtil.isPopulationSupervise(institutional)) && (orgName.contains("\u5e02\u5c40") || orgName.contains("\u603b\u961f"))) {
                return PopulationUrban;
            }
            if (orgName.contains("\u5206\u5c40")) {
                return SubUrb;
            }
            if (orgName.contains("\u5e02\u5c40") || orgName.contains("\u603b\u961f")) {
                return Urban;
            }
            return PoliceStation;
        }
        if (!StringUtil.isEmpty(institutional) && institutional.startsWith("04")) {
            return Proprietor;
        }
        return Company;
    }

    public static boolean isSupervise(String institutional) {
        return BusinessUtil.isSupervise(institutional);
    }
}

