package com.baichuanxin.openrestapi.controller;

import com.alibaba.fastjson.JSON;
import com.baichuanxin.openrestapi.service.NoticeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/apply")
public class OnlineRestController {
    @Autowired
    private NoticeService noticeService;

    /**
     * 接受办结通知
     */
    @PostMapping("/getNotice")
    public String getNotice(@RequestBody String noticeData)  {
        noticeService.getNotice(noticeData);
        Map<String,Object> map = new HashMap<>();
        map.put("code",0);
        map.put("msg","请求ID"+noticeData);
        String response = JSON.toJSONString(map);
        return response;
    }

    /**
     * 接受办结通知
     */
    @PostMapping(value="/getResultNotice", produces = "application/json")
    public String getResultNotice(@RequestBody String requestBody) {
        Map<String,Object>  requestBody1 = JSON.parseObject(requestBody,Map.class);
        String taskId = requestBody1.get("taskId").toString();
        noticeService.updateNoticeSentFileStatus(taskId,2);
        Map<String,Object> map = new HashMap<>();
        map.put("code",1);
        map.put("taskID",taskId);
        String response = JSON.toJSONString(map);
        return response;
    }
}
