package com.baichuanxin.openrestapi.service.impl.electroncard;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baichuanxin.openrestapi.common.utils.FileHandleUtil;
import com.baichuanxin.openrestapi.dao.mapper.electroncard.CertificateMapper;
import com.baichuanxin.openrestapi.entity.Notice;
import com.baichuanxin.openrestapi.entity.electroncard.Certificate;
import com.baichuanxin.openrestapi.service.electroncard.ElectronCardService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;


@Service
public class CertificateImpl extends ServiceImpl<CertificateMapper, Certificate> implements ElectronCardService {
    @Autowired
    private CertificateMapper certificateMapper;
    @Override
    public String getElectronCard(String name, String idCard)  {
        Map<String,Object> map = new HashMap<>();
        QueryWrapper<Certificate> queryWrapper =new QueryWrapper<>();
        queryWrapper.eq("item_status",1);
        queryWrapper.eq("item_securityName",name);
        queryWrapper.eq("item_documentID",idCard);
        queryWrapper.isNotNull("item_attachment");
        queryWrapper.orderByAsc("item_certificateDate");
        queryWrapper.last("LIMIT 1");
        Certificate certificate = certificateMapper.selectOne(queryWrapper);
        if (ObjectUtil.isNotNull(certificate) && StrUtil.isNotEmpty(certificate.getItemAttachment())){
            try {
                String baseCode  = FileHandleUtil.toCode(certificate.getItemAttachment());
                map.put("code","00");
                map.put("result","调用成功");
                map.put("baseStr",baseCode);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }else {
            map.put("code","99");
            map.put("result", "调用失败");
            map.put("baseStr", "false");
        }
        String response = JSON.toJSONString(map);
        return response;
    }

}
