package com.bcxin.backend.domain.models;

import com.bcxin.backend.domain.enums.LogStatus;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.Date;

@Getter
@Setter(AccessLevel.PROTECTED)
@Entity
@Table(name = "sys_log")
public class SyncLogSourceModel {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private long id;
    @Column(columnDefinition="TEXT")
    private String data;
    private String name;
    @Enumerated(EnumType.ORDINAL)
    private LogStatus status;
    @Column(columnDefinition="TEXT")
    private String message;

    @Column(name = "created_time")
    @Temporal(TemporalType.TIMESTAMP)
    private Date createdTime;
    private String category;

    public void change(LogStatus status,String message) {
        this.setStatus(status);
        this.setMessage(message);
        this.createdTime = new Date();
    }
}
