/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.push.android.getui;

import cn.wildfirechat.push.PushMessage;
import cn.wildfirechat.push.Utility;
import cn.wildfirechat.push.android.getui.GetuiConfig;
import com.getui.push.v2.sdk.ApiHelper;
import com.getui.push.v2.sdk.GtApiConfiguration;
import com.getui.push.v2.sdk.api.PushApi;
import com.getui.push.v2.sdk.common.ApiResult;
import com.getui.push.v2.sdk.dto.req.Audience;
import com.getui.push.v2.sdk.dto.req.Settings;
import com.getui.push.v2.sdk.dto.req.Strategy;
import com.getui.push.v2.sdk.dto.req.message.PushChannel;
import com.getui.push.v2.sdk.dto.req.message.PushDTO;
import com.getui.push.v2.sdk.dto.req.message.android.AndroidDTO;
import com.getui.push.v2.sdk.dto.req.message.android.GTNotification;
import com.getui.push.v2.sdk.dto.req.message.android.ThirdNotification;
import com.getui.push.v2.sdk.dto.req.message.android.Ups;
import com.getui.push.v2.sdk.dto.req.message.ios.Alert;
import com.getui.push.v2.sdk.dto.req.message.ios.Aps;
import com.getui.push.v2.sdk.dto.req.message.ios.IosDTO;
import com.google.gson.Gson;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class GetuiPush {
    private static final Logger LOG = LoggerFactory.getLogger(GetuiPush.class);
    @Autowired
    private GetuiConfig mConfig;
    private PushApi pushApi;

    @PostConstruct
    public void init() {
        try {
            System.setProperty("http.maxConnections", "200");
            GtApiConfiguration apiConfiguration = new GtApiConfiguration();
            if (!StringUtils.isEmpty((Object)this.mConfig.getAppId())) {
                apiConfiguration.setAppId(this.mConfig.getAppId());
                apiConfiguration.setAppKey(this.mConfig.getAppKey());
                apiConfiguration.setMasterSecret(this.mConfig.getMasterSecret());
                apiConfiguration.setDomain("https://restapi.getui.com/v2/");
                ApiHelper apiHelper = ApiHelper.build((GtApiConfiguration)apiConfiguration);
                this.pushApi = (PushApi)apiHelper.creatApi(PushApi.class);
            }
        }
        catch (Exception e) {
            LOG.error("GetuiPush init failed");
            e.printStackTrace();
        }
    }

    public void push(PushMessage pushMessage, boolean isAndroid) {
        String[] arr = Utility.getPushTitleAndContent((PushMessage)pushMessage);
        String title = arr[0];
        String body = arr[1];
        PushDTO pushDTO = new PushDTO();
        pushDTO.setRequestId(System.currentTimeMillis() + "");
        com.getui.push.v2.sdk.dto.req.message.PushMessage pm = new com.getui.push.v2.sdk.dto.req.message.PushMessage();
        pushDTO.setPushMessage(pm);
        Settings settings = new Settings();
        pushDTO.setSettings(settings);
        settings.setTtl(Integer.valueOf(259200000));
        Strategy strategy = new Strategy();
        settings.setStrategy(strategy);
        strategy.setDef(Integer.valueOf(1));
        GTNotification notification = new GTNotification();
        pm.setNotification(notification);
        notification.setTitle(title);
        notification.setBody(body);
        notification.setClickType("startapp");
        PushChannel pushChannel = new PushChannel();
        pushDTO.setPushChannel(pushChannel);
        AndroidDTO androidDTO = new AndroidDTO();
        pushChannel.setAndroid(androidDTO);
        Ups ups = new Ups();
        androidDTO.setUps(ups);
        ThirdNotification thirdNotification = new ThirdNotification();
        ups.setNotification(thirdNotification);
        thirdNotification.setTitle(title);
        thirdNotification.setBody(body);
        thirdNotification.setClickType("startapp");
        HashMap options = new HashMap();
        HashMap<String, Object> hw = new HashMap<String, Object>();
        hw.put("/message/android/category", "VOIP");
        hw.put("/message/android/notification/default_sound", false);
        hw.put("/message/android/notification/sound", "/raw/pushsound");
        options.put("HW", hw);
        HashMap<String, String> xm = new HashMap<String, String>();
        xm.put("/extra.sound_uri", "android.resource://com.bcxin.bbdhn/raw/pushsound");
        xm.put("/extra.channel_id", "109448");
        options.put("XM", xm);
        HashMap<String, String> vv = new HashMap<String, String>();
        vv.put("/category", "IM");
        options.put("VV", vv);
        HashMap<String, String> op = new HashMap<String, String>();
        op.put("/channel_id", "__UNI__359FBBE__01");
        options.put("OPG", op);
        HashMap<String, String> _ups = new HashMap<String, String>();
        _ups.put("bigText", title + "<br>" + pushMessage.pushContent);
        options.put("UPS", _ups);
        ups.setOptions(options);
        IosDTO iosDTO = new IosDTO();
        pushChannel.setIos(iosDTO);
        if (pushMessage.pushMessageType == 1 || pushMessage.pushMessageType == 2) {
            iosDTO.setType("voip");
        }
        iosDTO.setPayload(pushMessage.pushContent);
        iosDTO.setAutoBadge("+1");
        iosDTO.setApnsCollapseId("" + pushMessage.messageId);
        Aps aps = new Aps();
        iosDTO.setAps(aps);
        aps.setSound("pushsound.caf");
        aps.setCategory("ACTIONABLE");
        Alert alert = new Alert();
        aps.setAlert(alert);
        alert.setTitle(title);
        alert.setBody(body);
        Audience audience = new Audience();
        pushDTO.setAudience((Object)audience);
        audience.addCid(pushMessage.getDeviceToken());
        LOG.info("cid\u5355\u63a8\uff0ccid\uff1a\uff1a" + audience.getCid());
        LOG.info("\u4e2a\u63a8\u53c2\u6570\uff1a\uff1a" + new Gson().toJson((Object)pushDTO));
        ApiResult apiResult = this.pushApi.pushToSingleByCid(pushDTO);
        if (apiResult.isSuccess()) {
            LOG.info("success\uff1a" + new Gson().toJson((Object)apiResult));
        } else {
            LOG.info("code:" + apiResult.getCode() + ", msg: " + apiResult.getMsg());
        }
    }
}

