package com.zbkj.common.response.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentStyle;
import com.alibaba.excel.enums.poi.HorizontalAlignmentEnum;
import com.alibaba.excel.enums.poi.VerticalAlignmentEnum;
import lombok.Data;

/**
 * description: 业绩报表-部门成员导出excel dto对象
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
public class BcxPerformanceReportDepartmentMemberExcelDto extends BcxPerformanceReportBaseExcelDto {

    @ExcelProperty(value = "所属部门", order = 21)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String departmentName;

    @ExcelProperty(value = "成员名称", order = 22)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String departmentMemberName;

}