/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.weixin.web;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.vo.LOTEPolicyVo;
import com.bcxin.ins.weixin.order.service.WeiXinOrderService;
import com.bcxin.ins.weixin.util.CTLUtil;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.xiaoleilu.hutool.http.HttpUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${weixin}/order"})
@Lazy(value=false)
public class WeiXinOrderController
extends BaseController {
    private static Logger log = LoggerFactory.getLogger((String)"");
    private static final String INDEX = WeiXinOrderController.getViewPath((String)"weixin/order/");
    private static final String DETAIL = WeiXinOrderController.getViewPath((String)"weixin/order/order_detail");
    @Autowired
    private WeiXinOrderService weiXinOrderService;
    @Autowired
    private InsTransactionAPIService insTransactionAPIService;

    @RequestMapping(value={"/{index}"})
    public String login(Model model, @RequestParam Map<Object, Object> params, @PathVariable String index) {
        model.addAttribute("p", params);
        return INDEX + index;
    }

    @RequestMapping(value={"/detail"})
    public String detail(Model model, @RequestParam Map<Object, Object> params) {
        Map<Object, Object> p = CTLUtil.initWX(this.getRequest(), params);
        model.addAttribute("p", params);
        model.addAttribute("row", this.weiXinOrderService.queryDetailVoBySlipID(p, this.getRequest()));
        return DETAIL;
    }

    @RequestMapping(value={"/zzx/{jsppage}"})
    public String writeOrder1(Model model, @RequestParam Map<Object, Object> params, @PathVariable String jsppage) {
        Map<Object, Object> p = CTLUtil.initWX(this.getRequest(), params);
        if (p.get("ins_insurance_slip_id") != null || "".equals(String.valueOf(p.get("ins_insurance_slip_id")).trim())) {
            Map<Object, Object> row = this.weiXinOrderService.queryDetailVoBySlipID(p, this.getRequest());
            model.addAttribute("row", row);
            Map special = (Map)row.get("special");
            String ai = (String)special.get("activity_id");
            if (this.getRequest().getSession().getAttribute("ywzc_activity_info") == null && StringUtils.isNotEmpty((CharSequence)ai)) {
                String result = HttpUtil.get((String)(String.valueOf(GlobalResources.map.get("YWZC_URL")) + "/weixin/no/getActivity?id=" + ai));
                Map localParam = (Map)JSON.parseObject((String)result, Map.class);
                this.logger.info("\u83b7\u5f97\u7684\u53c2\u6570" + JSON.toJSONString((Object)localParam));
                this.getRequest().getSession().setAttribute("ywzc_activity_info", (Object)localParam);
            }
        } else {
            Object obj = this.getRequest().getSession().getAttribute("ins_insurance_slip_id");
            if (obj != null) {
                p.put("ins_insurance_slip_id", obj);
            }
        }
        model.addAttribute("p", p);
        model.addAttribute("ywzc_activity_info", this.getRequest().getSession().getAttribute("ywzc_activity_info"));
        return INDEX + "zzx/" + jsppage;
    }

    @RequestMapping(value={"/query"})
    @ResponseBody
    public Object query(@RequestParam Map<Object, Object> params, Model model) {
        CTLUtil.out(this.weiXinOrderService.query(CTLUtil.initWX(this.getRequest(), params)), this.getResponse());
        return null;
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_ORDER, title="\u3010\u8bf7\u6c42\u3011\u5fae\u4fe1-\u8ba2\u5355\u6295\u4fdd")
    @RequestMapping(value={"/save/applicant"})
    @ResponseBody
    public Object applicant(@RequestParam Map<Object, Object> params, Model model) {
        return this.weiXinOrderService.applicant(CTLUtil.initWX(this.getRequest(), params), this.getRequest());
    }

    @RequestMapping(value={"/save/insurant"})
    @ResponseBody
    public Object saveInsurant(@RequestParam Map<Object, Object> params, Model model) {
        return this.weiXinOrderService.saveInsurant(CTLUtil.initWX(this.getRequest(), params), this.getRequest());
    }

    @RequestMapping(value={"/save/special"})
    @ResponseBody
    public Object saveSpecial(@RequestParam Map<Object, Object> params, Model model) {
        return this.weiXinOrderService.saveSpecial(CTLUtil.initWX(this.getRequest(), params), this.getRequest());
    }

    @RequestMapping(value={"/save/insMailPolicy"})
    @ResponseBody
    public Object insMailPolicy(@RequestParam Map<Object, Object> params, Model model) {
        return this.weiXinOrderService.insMailPolicy(CTLUtil.initWX(this.getRequest(), params), this.getRequest());
    }

    @RequestMapping(value={"/queryDZBD"})
    @ResponseBody
    public Object queryDZBD(Model model, @RequestParam Map<Object, Object> params) {
        Map<Object, Object> p = CTLUtil.initWX(this.getRequest(), params);
        CTLUtil.out(this.weiXinOrderService.queryDZBDBySlipID(p), this.getResponse());
        return null;
    }

    @RequestMapping(value={"/detail/debug"})
    @ResponseBody
    public Object detailDebug(Model model, @RequestParam Map<Object, Object> params) {
        Map<Object, Object> p = CTLUtil.initWX(this.getRequest(), params);
        CTLUtil.out(this.weiXinOrderService.queryDetailVoBySlipID(p, this.getRequest()), this.getResponse());
        return null;
    }

    @RequestMapping(value={"/zzx/payment_pac/{oid}"})
    public String detail(Model model, @PathVariable(value="oid") String oid) {
        model.addAttribute("oid", (Object)oid);
        return INDEX + "zzx/policyPayment_PAC";
    }

    @RequestMapping(value={"/zzx/payment_ya/{oid}"})
    public String payment_ya(Model model, @PathVariable(value="oid") long oid) {
        List tList = this.insTransactionAPIService.selectInsTransactionByInsOrderForm(Long.valueOf(oid));
        if (tList.size() > 0) {
            String du = ((InsTransaction)tList.get(0)).getDeal_url();
            model.addAttribute("deal_url", (Object)du);
        }
        return INDEX + "zzx/policy_payment_ya";
    }

    @RequestMapping(value={"/save/saveLOTEOrder"})
    @ResponseBody
    public Object saveLOTEOrder(LOTEPolicyVo vo, Model model) {
        return this.weiXinOrderService.pendingLOTEPolicyVoPolicy(vo, "");
    }

    @RequestMapping(value={"/orderPage/{jsppage}"})
    public String orderPage(Model model, @RequestParam Map<Object, Object> params, @PathVariable String jsppage) {
        Map<Object, Object> p = CTLUtil.initWX(this.getRequest(), params);
        if (p.get("ins_insurance_slip_id") != null || "".equals(String.valueOf(p.get("ins_insurance_slip_id")).trim())) {
            model.addAttribute("row", this.weiXinOrderService.queryDetailVoBySlipID(p, this.getRequest()));
        } else {
            Object obj = this.getRequest().getSession().getAttribute("ins_insurance_slip_id");
            if (obj != null) {
                p.put("ins_insurance_slip_id", obj);
            }
        }
        model.addAttribute("p", p);
        model.addAttribute("ywzc_activity_info", this.getRequest().getSession().getAttribute("ywzc_activity_info"));
        return INDEX + "orderPage/" + jsppage;
    }
}

