/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.web.interceptor;

import com.bcxin.ins.core.util.SysLogUtils;
import com.bcxin.ins.util.toolbox.DateUtil;
import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NamedThreadLocal;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class SysLogInterceptor
implements HandlerInterceptor {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final ThreadLocal<Long> startTimeThreadLocal = new NamedThreadLocal("ThreadLocal StartTime");

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (request.getRequestURI().indexOf("DictLabel") > 0) {
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            long beginTime = System.currentTimeMillis();
            startTimeThreadLocal.set(beginTime);
            this.logger.debug("\u5f00\u59cb\u8ba1\u65f6: {}  URI: {}", (Object)new SimpleDateFormat("hh:mm:ss.SSS").format(beginTime), (Object)request.getRequestURI());
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (modelAndView != null) {
            this.logger.info("ViewName: " + modelAndView.getViewName());
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        SysLogUtils.saveLog((HttpServletRequest)request, (Object)handler, (Exception)ex, null);
        if (request.getRequestURI().indexOf("DictLabel") > 0) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            long beginTime = startTimeThreadLocal.get();
            long endTime = System.currentTimeMillis();
            this.logger.debug("\u8ba1\u65f6\u7ed3\u675f\uff1a{}  \u8017\u65f6\uff1a{}  URI: {}  \u6700\u5927\u5185\u5b58: {}m  \u5df2\u5206\u914d\u5185\u5b58: {}m  \u5df2\u5206\u914d\u5185\u5b58\u4e2d\u7684\u5269\u4f59\u7a7a\u95f4: {}m  \u6700\u5927\u53ef\u7528\u5185\u5b58: {}m", new Object[]{new SimpleDateFormat("hh:mm:ss.SSS").format(endTime), DateUtil.formatDateTime((long)(endTime - beginTime)), request.getRequestURI(), Runtime.getRuntime().maxMemory() / 1024L / 1024L, Runtime.getRuntime().totalMemory() / 1024L / 1024L, Runtime.getRuntime().freeMemory() / 1024L / 1024L, (Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory()) / 1024L / 1024L});
        }
    }
}

