/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.task.base.config;

import com.bcxin.ins.common.constants.GlobalConstants;
import com.bcxin.ins.entity.common.ComTaskCron;
import com.bcxin.ins.spring.util.SpringContextHolder;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.ScheduledMethodRunnable;

public class TaskConfig {
    private Logger logger = LoggerFactory.getLogger(TaskConfig.class);
    public static Map<Long, ComTaskCron> TASKS = Maps.newConcurrentMap();
    public static Map<Long, ScheduledFuture<?>> SCHEDULED_FUTURE = Maps.newConcurrentMap();
    private static TaskConfig taskConfig;
    public final ConcurrentTaskScheduler ct = new ConcurrentTaskScheduler(Executors.newScheduledThreadPool(StrUtil.toInteger((Object)GlobalConstants.getConfig((String)"task.pool"))));

    private TaskConfig() {
    }

    public static synchronized TaskConfig getInstance() {
        if (taskConfig == null) {
            taskConfig = new TaskConfig();
        }
        return taskConfig;
    }

    public void start(ComTaskCron task) {
        if (task.getCom_task_cron_id() == null) {
            throw new RuntimeException("\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((String)task.getCron_expression())) {
            throw new RuntimeException("\u4efb\u52a1\u7684\u8c03\u5ea6\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        if (SCHEDULED_FUTURE.get(task.getCom_task_cron_id()) != null) {
            return;
        }
        ScheduledFuture scheduledFuture = null;
        try {
            scheduledFuture = this.ct.schedule((Runnable)new ScheduledMethodRunnable(SpringContextHolder.getBean((String)task.getTarget_object().trim()), task.getTask_method()), (Trigger)new CronTrigger(task.getCron_expression()));
            SCHEDULED_FUTURE.put(task.getCom_task_cron_id(), scheduledFuture);
            TASKS.put(task.getCom_task_cron_id(), task);
            this.logger.info("\u4efb\u52a1: " + task.getName() + "\u542f\u52a8\u6210\u529f");
        }
        catch (NoSuchMethodException e) {
            this.logger.info("\u4efb\u52a1: " + task.getName() + "\u542f\u52a8\u5931\u8d25,\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u65b9\u6cd5");
        }
    }

    public void stop(Long taskId) {
        this.logger.info("\u6b63\u5728\u505c\u6b62\u4efb\u52a1 " + taskId);
        if (taskId == null) {
            throw new RuntimeException("\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            ScheduledFuture<?> scheduledFuture = SCHEDULED_FUTURE.remove(taskId);
            TASKS.remove(taskId);
            if (scheduledFuture == null) {
                return;
            }
            if (!scheduledFuture.isCancelled()) {
                Thread.sleep(100L);
                scheduledFuture.cancel(true);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u4efb\u52a1\u505c\u6b62\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public void resetTrigger(Long taskId, String cronExpression) {
        this.logger.info("\u6b63\u5728\u4fee\u6539\u5f53\u524d\u4efb\u52a1 " + taskId + "\u6267\u884c\u9891\u7387.");
        if (taskId == null) {
            throw new RuntimeException("\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((String)cronExpression)) {
            throw new RuntimeException("\u4efb\u52a1\u7684\u8c03\u5ea6\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        ComTaskCron task = TASKS.get(taskId);
        if (task != null) {
            if (cronExpression.equals(task.getCron_expression())) {
                return;
            }
            ScheduledFuture scheduledFuture = SCHEDULED_FUTURE.remove(taskId);
            scheduledFuture.cancel(false);
            try {
                task.setCron_expression(cronExpression);
                scheduledFuture = this.ct.schedule((Runnable)new ScheduledMethodRunnable(SpringContextHolder.getBean((String)task.getTarget_object().trim()).getClass(), task.getTask_method()), (Trigger)new CronTrigger(task.getCron_expression()));
                SCHEDULED_FUTURE.put(taskId, scheduledFuture);
            }
            catch (NoSuchMethodException e) {
                this.logger.info("\u4efb\u52a1: " + task.getName() + "\u8bbe\u7f6e\u5931\u8d25,\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u65b9\u6cd5");
            }
        }
    }

    public void onlyOneTime(ComTaskCron task) {
        try {
            this.ct.execute((Runnable)new ScheduledMethodRunnable(SpringContextHolder.getBean((String)task.getTarget_object().trim()).getClass(), task.getTask_method()), 2000L);
        }
        catch (NoSuchMethodException e) {
            this.logger.info("\u4efb\u52a1: " + task.getName() + "\u542f\u52a8\u5931\u8d25,\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u65b9\u6cd5");
        }
    }

    public void destrory() {
        this.logger.info("\u6b63\u5728\u7ec8\u6b62\u81ea\u52a8\u4efb\u52a1\u7684\u7ebf\u7a0b\u6c60\u8d44\u6e90.");
        ScheduledExecutorService scheduledExecutor = (ScheduledExecutorService)this.ct.getConcurrentExecutor();
        try {
            scheduledExecutor.shutdownNow();
        }
        catch (Exception e) {
            this.logger.info("\u81ea\u52a8\u4efb\u52a1\u7684\u7ebf\u7a0b\u6c60\u8d44\u6e90\u6e05\u7406\u53d1\u751f\u5f02\u5e38.", (Throwable)e);
        }
        finally {
            this.logger.info("\u81ea\u52a8\u4efb\u52a1\u7684\u7ebf\u7a0b\u6c60\u8d44\u6e90\u6e05\u7406\u5b8c\u6210.");
        }
    }
}

