/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.supply.business.impl;

import com.bcxin.ins.entity.policy_core.InsAgreement;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsMailPolicy;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.entity.policy_core.InsUnderwrite;
import com.bcxin.ins.service.order.InsAgreementAPIService;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsMailPolicyAPIService;
import com.bcxin.ins.service.order.InsRoleInpolicyAPIService;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.InsUnderwriteAPIService;
import com.bcxin.ins.supply.business.BizInsureService;
import com.bcxin.ins.supply.business.entity.InsureAgreementView;
import com.bcxin.ins.supply.business.entity.InsureCommonView;
import com.bcxin.ins.supply.business.entity.InsureMailPolicyView;
import com.bcxin.ins.supply.business.entity.InsureOrderView;
import com.bcxin.ins.supply.business.entity.InsureRoleInpolicyView;
import com.bcxin.ins.supply.business.entity.InsureTransactionView;
import com.bcxin.ins.supply.business.entity.InsureUnderwriteView;
import com.bcxin.ins.utils.CopyUtil;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BizInsureServiceImpl
implements BizInsureService {
    @Autowired
    private InsInsuranceSlipAPIService orderService;
    @Autowired
    private InsAgreementAPIService agreementService;
    @Autowired
    private InsMailPolicyAPIService mailPostService;
    @Autowired
    private InsTransactionAPIService transactionService;
    @Autowired
    private InsRoleInpolicyAPIService policyService;
    @Autowired
    private InsUnderwriteAPIService underwriteService;

    @Override
    public InsureCommonView getInsureCommonView(Map<String, Object> map, Long orderId) {
        try {
            InsureCommonView commonView = new InsureCommonView();
            InsInsuranceSlip insInsuranceSlip = this.orderService.selectById(orderId);
            InsureOrderView orderView = CopyUtil.copy(insInsuranceSlip, new InsureOrderView());
            InsAgreement insAgreement = (InsAgreement)this.agreementService.selectOne(new EntityWrapper().addFilter("ins_insurance_slip_id={0}", new Object[]{orderId}));
            InsureAgreementView agreementView = CopyUtil.copy(insAgreement, new InsureAgreementView());
            InsTransaction insTransaction = (InsTransaction)this.transactionService.selectOne(new EntityWrapper().addFilter("insurance_slip_id={0}", new Object[]{orderId}));
            InsureTransactionView transactionView = CopyUtil.copy(insTransaction, new InsureTransactionView());
            List policys = this.policyService.selectList(new EntityWrapper().addFilter("insurance_slip_id={0}", new Object[]{orderId}));
            ArrayList<InsureRoleInpolicyView> policyList = new ArrayList<InsureRoleInpolicyView>();
            for (Object p : policys) {
                policyList.add(CopyUtil.copy(p, new InsureRoleInpolicyView()));
            }
            ArrayList<InsureRoleInpolicyView> benefitViewList = new ArrayList<InsureRoleInpolicyView>();
            for (InsureRoleInpolicyView tmp : policyList) {
                if (tmp.getKind().equals("1")) {
                    commonView.setPolicyHolderView(tmp);
                    continue;
                }
                benefitViewList.add(tmp);
            }
            commonView.setOrderView(orderView);
            commonView.setAgreementView(agreementView);
            commonView.setTransactionView(transactionView);
            commonView.setBenefitViewList(benefitViewList);
            if (orderView != null) {
                InsUnderwrite insUnderwrite = (InsUnderwrite)this.underwriteService.selectOne(new EntityWrapper().addFilter("underwrite_id={0}", new Object[]{orderView.getUnderwrite()}));
                InsureUnderwriteView underwriteView = CopyUtil.copy(insUnderwrite, new InsureUnderwriteView());
                commonView.setUnderwriteView(underwriteView);
            }
            if (agreementView != null) {
                InsMailPolicy insMailPolicy = (InsMailPolicy)this.mailPostService.selectOne(new EntityWrapper().addFilter("ins_mail_policy_id={0}", new Object[]{agreementView.getMail_policy_id()}));
                InsureMailPolicyView mailPostView = CopyUtil.copy(insMailPolicy, new InsureMailPolicyView());
                commonView.setMailPostView(mailPostView);
            }
            return commonView;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

