/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.supply.business;

import com.bcxin.ins.supply.SupplyType;
import com.bcxin.ins.supply.business.BizStrategy;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BizStrategyFactory {
    private Map<String, BizStrategy> contextStrategy = new HashMap<String, BizStrategy>();

    public Map<String, BizStrategy> getContextStrategy() {
        return this.contextStrategy;
    }

    @Autowired
    public void setContextStrategy(Map<String, BizStrategy> contextStrategy) {
        HashMap<String, BizStrategy> newMap = new HashMap<String, BizStrategy>();
        for (String key : contextStrategy.keySet()) {
            BizStrategy biz = contextStrategy.get(key);
            SupplyType supplyTypeAnno = this.handleAnnotation(biz);
            if (supplyTypeAnno == null) continue;
            newMap.put(supplyTypeAnno.type().getKey(), biz);
        }
        this.contextStrategy = newMap;
    }

    public BizStrategy getStrategy(String type) {
        BizStrategy businessStrategy = this.contextStrategy.get(type);
        if (businessStrategy == null) {
            throw new RuntimeException("\u7b56\u7565\u83b7\u5f97\u5931\u8d25");
        }
        return businessStrategy;
    }

    private SupplyType handleAnnotation(BizStrategy clazz) {
        Annotation[] annotations = clazz.getClass().getDeclaredAnnotations();
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        for (int i = 0; i < annotations.length; ++i) {
            if (!(annotations[i] instanceof SupplyType)) continue;
            return (SupplyType)annotations[i];
        }
        return null;
    }
}

