/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.product.web;

import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.SysCompany;
import com.bcxin.ins.core.service.SysCompanyService;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.models.product.service.InsProductService;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsProductVo;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

@Controller
@SessionAttributes(value={"productVo"})
@RequestMapping(value={"${systemPath}/ins/product"})
public class InsProductController
extends BaseController {
    private static final String PRODUCT_LIST = InsProductController.getViewPath((String)"admin/product/product_list");
    private static final String PRODUCT_CHANGE_LIST = InsProductController.getViewPath((String)"admin/product/product_change_list");
    private static final String PRODUCT_COMPANY_LIST = InsProductController.getViewPath((String)"admin/product/product_company_list");
    private static final String PRODUCT_FEE_DATA = InsProductController.getViewPath((String)"admin/product/product_fee_data");
    private static final String PRODUCT_DETATIL = InsProductController.getViewPath((String)"admin/product/product_list");
    private static final String PRODUCT_FEE_LIST_ONE = InsProductController.getViewPath((String)"admin/product/product_change_list_one");
    private static final String PRODUCT_FEE_DATA_ONE = InsProductController.getViewPath((String)"admin/product/product_fee_data_one");
    private static final String PRODUCT_COMPANY_LIST_ONE = InsProductController.getViewPath((String)"admin/product/product_company_list_one");
    @Autowired
    private InsProductService insProductService;
    @Autowired
    private SysCompanyService sysCompanyService;

    @RequiresPermissions(value={"product:list:view"})
    @RequestMapping(value={"/list"})
    public String list(ModelMap model, DwzPage page) {
        ProPrimary insProduct = new ProPrimary();
        String type = this.getParameter("type");
        List<ProPrimary> plst = this.insProductService.findProductList(insProduct);
        model.addAttribute("plst", plst);
        return PRODUCT_LIST;
    }

    @RequiresPermissions(value={"product:list:change"})
    @RequestMapping(value={"/changeList"})
    public String changeList(ModelMap model, DwzPage page) {
        List<ProPrimary> plst = this.insProductService.findProductList(new ProPrimary());
        model.addAttribute("plst", plst);
        return PRODUCT_CHANGE_LIST;
    }

    @RequiresPermissions(value={"product:list:change"})
    @RequestMapping(value={"/saveNextCompany"})
    public ModelAndView saveNextCompany(ModelMap model) {
        InsProductVo productVo = new InsProductVo();
        String[] pids = this.getRequest().getParameterValues("productName");
        if (pids.length <= 0) {
            return new ModelAndView("redirect:changeList");
        }
        List<ProPrimary> plist = this.insProductService.fillProductList(pids);
        productVo.setPlist(plist);
        model.put((Object)"productVo", (Object)productVo);
        return new ModelAndView("redirect:companylist");
    }

    @RequiresPermissions(value={"product:list:change"})
    @RequestMapping(value={"/companylist"})
    public String companylist(ModelMap model, DwzPage page) {
        List slist = this.sysCompanyService.getDistributorListByLevel("1");
        model.put((Object)"slist", (Object)slist);
        return PRODUCT_COMPANY_LIST;
    }

    @RequiresPermissions(value={"product:list:change"})
    @RequestMapping(value={"/saveNextFeeData"})
    public ModelAndView saveNextFeeData(ModelMap model) {
        InsProductVo productVo = (InsProductVo)model.get((Object)"productVo");
        String[] cids = this.getRequest().getParameterValues("companyName");
        if (cids.length <= 0) {
            return new ModelAndView("redirect:changeList");
        }
        List<SysCompany> slist = this.insProductService.fillCompanyList(cids);
        productVo.setSlist(slist);
        model.put((Object)"productVo", (Object)productVo);
        return new ModelAndView("redirect:fillFeeData");
    }

    @RequiresPermissions(value={"product:list:change"})
    @RequestMapping(value={"/fillFeeData"})
    public String fillFeeData(ModelMap model) {
        InsProductVo productVo = (InsProductVo)model.get((Object)"productVo");
        if (productVo == null) {
            return "redirect:changeList";
        }
        List plst = productVo.getPlist();
        model.addAttribute("plst", (Object)plst);
        model.addAttribute("slist", (Object)productVo.getSlist());
        return PRODUCT_FEE_DATA;
    }

    @RequiresPermissions(value={"product:list:change"})
    @RequestMapping(value={"/saveCompanyBrokerage"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult saveCompanyBrokerage(ModelMap model) {
        InsProductVo productVo = (InsProductVo)model.get((Object)"productVo");
        if (productVo == null) {
            return this.fail(true, "\u8bf7\u91cd\u65b0\u83b7\u53d6\u4ea7\u54c1\uff01\uff01\uff01");
        }
        return this.success(true, "\u4fdd\u5b58\u4f63\u91d1\u5217\u8868\u6210\u529f!");
    }

    @RequestMapping(value={"/findProductKeyword"})
    public String findProductKeyword(ModelMap model, String keyword) {
        List<ProPrimary> plst = this.insProductService.findProductList(keyword);
        model.addAttribute("plst", plst);
        model.addAttribute("keyword", (Object)keyword);
        return PRODUCT_CHANGE_LIST;
    }

    @RequestMapping(value={"/getProduct/{oid}"})
    public String getProduct(@PathVariable Long oid, ModelMap model) {
        return PRODUCT_DETATIL;
    }

    @RequiresPermissions(value={"product:list:productList:one"})
    @RequestMapping(value={"/findProductKeywordOne"})
    public String findProductKeywordOne(ModelMap model, String keyword) {
        List<ProPrimary> plst = this.insProductService.findProductList(keyword);
        model.addAttribute("plst", plst);
        model.addAttribute("keyword", (Object)keyword);
        model.addAttribute("companyId", (Object)this.getParameter("companyId"));
        return PRODUCT_FEE_LIST_ONE;
    }

    @RequiresPermissions(value={"product:list:productList:one"})
    @RequestMapping(value={"/list/companyToProductList"})
    public String companyToProductList(Model model) {
        String companyId = this.getParameter("companyId");
        String level = this.getParameter("level");
        String parentId = this.getParameter("parentId");
        if (StrUtil.isNotBlank((CharSequence)companyId)) {
            model.addAttribute("companyId", (Object)companyId);
            model.addAttribute("level", (Object)level);
            model.addAttribute("parentId", (Object)parentId);
        }
        return PRODUCT_COMPANY_LIST_ONE;
    }

    @RequiresPermissions(value={"product:list:productList:one"})
    @RequestMapping(value={"/list/openProductList"})
    public String openProductList(Model model) {
        String companyId = this.getParameter("companyId");
        String productIds = this.getParameter("productIds");
        if (StrUtil.isNotBlank((CharSequence)companyId)) {
            model.addAttribute("companyId", (Object)companyId);
        }
        if (StrUtil.isNotBlank((CharSequence)companyId)) {
            model.addAttribute("productIds", (Object)productIds);
        }
        String level = this.getParameter("level");
        String parentId = this.getParameter("parentId");
        List<Object> plst = Lists.newArrayList();
        if (!"2".equals(level) && !"3".equals(level)) {
            plst = this.insProductService.findProductList(new ProPrimary());
        }
        model.addAttribute("plst", (Object)plst);
        model.addAttribute("level", (Object)level);
        model.addAttribute("parentId", (Object)parentId);
        return PRODUCT_FEE_LIST_ONE;
    }

    @RequiresPermissions(value={"product:list:productList:one"})
    @RequestMapping(value={"/list/openProductSetFeeOne"})
    public String openProductSetFee(Model model) {
        String companyId = this.getParameter("companyId");
        String productIds = this.getParameter("productIds");
        if (StrUtil.isNotBlank((CharSequence)companyId)) {
            model.addAttribute("companyId", (Object)companyId);
            model.addAttribute("company", (Object)this.sysCompanyService.get(StrUtil.toLong((Object)companyId)));
        }
        if (StrUtil.isNotBlank((CharSequence)productIds)) {
            List<ProPrimary> plst = this.insProductService.findByIdsArray(StrUtil.StrArr2LongArras((String[])productIds.split(",")), companyId);
            model.addAttribute("plst", plst);
            model.addAttribute("productIds", (Object)productIds);
        }
        return PRODUCT_FEE_DATA_ONE;
    }

    @RequestMapping(value={"/list/audit"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult audit() {
        Long pId = Long.parseLong(this.getParameter("accountId"));
        Integer status = Integer.valueOf(this.getParameter("status"));
        ProPrimary product = new ProPrimary();
        product.setPro_primary_id(pId);
        product.setStatus(status);
        this.insProductService.updateById(product);
        return this.success(true);
    }

    @RequiresPermissions(value={"product:list:delete:configure"})
    @RequestMapping(value={"/list/{accountId}/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult delete(@PathVariable Long accountId) {
        return this.success(true);
    }
}

