/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.product.service.impl;

import com.bcxin.ins.core.dao.SysCompanyDao;
import com.bcxin.ins.core.entity.SysCompany;
import com.bcxin.ins.core.service.SysCompanyService;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.entity.product_core.ProPrimaryExpire;
import com.bcxin.ins.models.product.dao.InsProductDao;
import com.bcxin.ins.models.product.service.InsProductService;
import com.bcxin.ins.models.product.service.InsProductggService;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.AdviceNoteVo;
import com.bcxin.ins.vo.InsProductVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InsProductServiceImpl
extends ServiceImpl<InsProductDao, ProPrimary>
implements InsProductService {
    @Autowired
    private InsProductDao dao;
    @Autowired
    private SysCompanyDao sysCompanyDao;
    @Autowired
    private InsProductggService insProductggService;
    @Autowired
    private SysCompanyService sysCompanyService;

    @Override
    public List<ProPrimary> findProductList(ProPrimary insProduct) {
        return this.dao.findProductList(insProduct);
    }

    @Override
    public List<ProPrimary> findProductList(String keyword) {
        return this.dao.selectInsProductListByCondition(keyword);
    }

    @Override
    public ProPrimary findProductByCode(String code) {
        return this.dao.getInsProductgByCode(code);
    }

    @Override
    public List<ProPrimary> fillProductList(String[] pids) {
        ArrayList<ProPrimary> plist = new ArrayList<ProPrimary>();
        for (String pid : pids) {
            ProPrimary product = this.dao.getProduct(Long.parseLong(pid));
            plist.add(product);
        }
        return plist;
    }

    @Override
    public List<SysCompany> fillCompanyList(String[] cids) {
        ArrayList<SysCompany> slist = new ArrayList<SysCompany>();
        for (String cid : cids) {
            SysCompany sysCompany = (SysCompany)this.sysCompanyDao.selectById((Serializable)Long.valueOf(Long.parseLong(cid)));
            slist.add(sysCompany);
        }
        return slist;
    }

    @Override
    public InsProductVo getProductAttrListByPid(Long pid, String type) {
        return this.dao.getProductAttrListByPid(pid, type);
    }

    @Override
    public ProPrimary getProduct(Long pid) {
        return this.dao.getProduct(pid);
    }

    @Override
    public void accordingToProductIDToGetInsProductSetUpOrderFormVo(OrderFormVo vo, Long insProduct_id) {
        ProPrimary insProduct = this.dao.getProduct(insProduct_id);
        if (insProduct != null) {
            SysCompany sysCompany;
            ProPrimaryExpire insProductgg = this.insProductggService.getInsProductggByInsProductID(insProduct.getPro_primary_id());
            if (insProductgg != null) {
                vo.setFees_for(insProductgg.getFees_for());
                vo.setPay_methods(insProductgg.getPay_methods());
            }
            vo.setProduct_name(insProduct.getInsurance_name());
            vo.setProduct_code(insProduct.getProduct_code());
            if (insProduct.getSupplier_id() != null && (sysCompany = (SysCompany)this.sysCompanyService.selectById((Serializable)insProduct.getSupplier().getSys_ins_company_id())) != null) {
                vo.setInsurance_name(sysCompany.getCompanyName());
            }
        }
    }

    @Override
    public void accordingToProductIDToGetInsProductSetUpAdviceNoteVo(AdviceNoteVo vo, Long insProduct_id) {
        ProPrimary insProduct = this.dao.getProduct(insProduct_id);
        if (insProduct != null) {
            SysCompany sysCompany;
            ProPrimaryExpire insProductgg = this.insProductggService.getInsProductggByInsProductID(insProduct.getPro_primary_id());
            if (insProductgg != null) {
                vo.setPay_methods(insProductgg.getPay_methods());
            }
            vo.setProduct_name(insProduct.getInsurance_name());
            vo.setProduct_type(insProduct.getProduct_type());
            if (insProduct.getSupplier() != null && (sysCompany = (SysCompany)this.sysCompanyService.selectById((Serializable)insProduct.getSupplier().getSys_ins_company_id())) != null) {
                vo.setCompany_ename(sysCompany.getCompanyEName());
                vo.setCompany_name(sysCompany.getCompanyName());
                vo.setShort_name(sysCompany.getShortName());
                vo.setRegistered_address(sysCompany.getRegisteredAddress());
                vo.setBank_name(sysCompany.getBankName());
                vo.setBank_account(sysCompany.getBankAccount());
                vo.setBank_account_name(sysCompany.getBankAccountName());
            }
        }
    }

    @Override
    public List<ProductVo> selectProductVoList(ProPrimary insProduct) {
        ArrayList<ProductVo> voList = new ArrayList<ProductVo>();
        List<ProPrimary> productList = this.dao.findProductList(insProduct);
        for (ProPrimary ip : productList) {
            voList.add(this.willInsProductSetUpProductVo(ip));
        }
        return voList;
    }

    @Override
    public ProductVo accordingToInsProductIDToGetInsProductInProductVo(Long insProductID) {
        ProPrimary ip = this.dao.getProduct(insProductID);
        if (ip != null) {
            return this.willInsProductSetUpProductVo(ip);
        }
        return null;
    }

    @Override
    public ProductVo willInsProductSetUpProductVo(ProPrimary ip) {
        SysCompany sysCompany;
        ProductVo vo = new ProductVo();
        vo.setOid(String.valueOf(ip.getPro_primary_id()));
        vo.setProduct_name(ip.getInsurance_name());
        vo.setProduct_code(ip.getProduct_code());
        if (ip.getSupplier() != null && (sysCompany = (SysCompany)this.sysCompanyService.selectById((Serializable)ip.getSupplier().getSys_ins_company_id())) != null) {
            vo.setInsurance_name(sysCompany.getCompanyName());
        }
        return vo;
    }

    @Override
    public List<ProPrimary> findByIdsList(List<Long> ids) {
        return this.dao.findByIdsList(ids);
    }

    @Override
    public List<ProPrimary> findByIdsArray(Long[] ids, String companyId) {
        SysCompany sysCompany = this.sysCompanyService.get(StrUtil.toLong((Object)companyId));
        List<Object> list = Lists.newArrayList();
        if (sysCompany.getCompanyType().equals(SysCompany.COMPANY_TYPE_CHANNEL)) {
            list = this.dao.findByIdsArray(ids);
        } else if (sysCompany.getCompanyType().equals(SysCompany.COMPANY_TYPE_DISTRIBUTOR)) {
            list = "2".equals(sysCompany.getDistributionLevel()) || "3".equals(sysCompany.getDistributionLevel()) ? this.dao.findByIdsArrayDistributor(ids, StrUtil.obj2Str((Object)sysCompany.getParent().getId())) : this.dao.findByIdsArrayDistributor(ids, null);
        }
        return list;
    }
}

