/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.order.policy.web;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.SysDict;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.core.util.SysUserUtils;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.entity.policy_core.InsShipDeclare;
import com.bcxin.ins.entity.policy_core.InsShipInvoices;
import com.bcxin.ins.entity.policy_special.StTopBuyers;
import com.bcxin.ins.models.order.policy.service.InsInsuranceSlipService;
import com.bcxin.ins.models.order.policy.service.InsTopBuyersService;
import com.bcxin.ins.models.order.policy.service.ShipDeclareService;
import com.bcxin.ins.models.order.policy.service.ShipInvoicesService;
import com.bcxin.ins.vo.ShipDeclareHtIndexVo;
import com.bcxin.ins.vo.ShipDeclareVo;
import com.bcxin.ins.vo.SysDictVo;
import com.bcxin.ins.vo.TopBuyersVo;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"${systemPath}/ship/ht/declare"})
public class ShipDeclareHtController
extends BaseController {
    @Autowired
    private ShipDeclareService shipDeclareService;
    @Autowired
    private ShipInvoicesService shipInvoicesService;
    @Autowired
    private InsInsuranceSlipService insInsuranceSlipService;
    @Autowired
    private InsTopBuyersService insTopBuyersService;
    private static final String ORDER_LIST = ShipDeclareHtController.getViewPath((String)"admin/shipment/declare/shipdeclare_manager_list");
    private static final String EXPORTS_CREDIT_DETATIL = ShipDeclareHtController.getViewPath((String)"admin/shipment/declare/shipdeclare_credit_detatil");
    private static final String ADMIN_LOGIN = ShipDeclareHtController.getViewPath((String)"admin/login/admin_login");

    @RequestMapping(value={"/findOrderList"})
    public String findOrderList(ModelMap model) {
        SysUser user = SysUserUtils.getUser();
        if (user == null) {
            return ADMIN_LOGIN;
        }
        List<ShipDeclareHtIndexVo> lis = this.shipDeclareService.getAllShipDeclare();
        model.addAttribute("shipDeclareList", lis);
        return ORDER_LIST;
    }

    private List<String> getInsuredNameList(Long orderFormId) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.packagingInsInsuranceSlip(orderFormId);
        if (insInsuranceSlip != null) {
            List insRoleInpolicy = insInsuranceSlip.getRolesOfKind("1");
            ArrayList<String> insuredNameList = new ArrayList<String>();
            if (insRoleInpolicy != null) {
                for (InsRoleInpolicy role : insRoleInpolicy) {
                    insuredNameList.add(role.getName_cn());
                }
            }
            return insuredNameList != null ? insuredNameList : null;
        }
        return null;
    }

    private List<SysDictVo> getPaymentTermsList() {
        List paymentTerms = SysDictUtils.getDictList((String)"paymentTerms");
        ArrayList<SysDictVo> paymentTermsList = new ArrayList<SysDictVo>();
        for (SysDict sysDict : paymentTerms) {
            SysDictVo sdv = new SysDictVo();
            sdv.setValue(sysDict.getValue());
            sdv.setType(sysDict.getType());
            sdv.setLabel(sysDict.getLabel());
            paymentTermsList.add(sdv);
        }
        return paymentTermsList;
    }

    private List<SysDictVo> getTransportTypeList() {
        List transportType = SysDictUtils.getDictList((String)"transportType");
        ArrayList<SysDictVo> transportTypeList = new ArrayList<SysDictVo>();
        for (SysDict sysDict : transportType) {
            SysDictVo sdv = new SysDictVo();
            sdv.setValue(sysDict.getValue());
            sdv.setType(sysDict.getType());
            sdv.setLabel(sysDict.getLabel());
            transportTypeList.add(sdv);
        }
        return transportTypeList;
    }

    @RequestMapping(value={"/goDetail/{externalReference}/{declareId}/{invoiceId}"})
    public String goDetail(ModelMap model, @PathVariable String externalReference, @PathVariable Long declareId, @PathVariable Long invoiceId) throws IllegalAccessException, InvocationTargetException {
        ShipDeclareVo shipDeclareVo = new ShipDeclareVo();
        InsShipDeclare shipDeclare = (InsShipDeclare)this.shipDeclareService.selectById(declareId);
        InsShipInvoices shipInvoices = (InsShipInvoices)this.shipInvoicesService.selectById(invoiceId);
        BeanUtils.copyProperties((Object)shipDeclareVo, (Object)shipDeclare);
        Long insTopBuyersId = shipDeclare.getSt_top_buyers_id();
        StTopBuyers insTopBuyers = (StTopBuyers)this.insTopBuyersService.selectById(insTopBuyersId);
        String code = insTopBuyers.getCom_buyer().getCode();
        TopBuyersVo buyers = this.insTopBuyersService.getBuyersVoById(insTopBuyersId);
        model.put((Object)"topBuyersVo", (Object)buyers);
        model.put((Object)"external_reference", (Object)externalReference);
        model.put((Object)"code", (Object)code);
        model.put((Object)"insTopBuyersId", (Object)shipDeclare.getSt_top_buyers_id());
        model.put((Object)"orderFormId", (Object)shipDeclare.getInsurance_slip_id());
        model.put((Object)"shipDeclareVo", (Object)shipDeclareVo);
        model.put((Object)"paymentTermsList", this.getPaymentTermsList());
        model.put((Object)"transportTypeList", this.getTransportTypeList());
        return EXPORTS_CREDIT_DETATIL;
    }
}

